/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.exceptions.UnknownTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.BinaryNode;
import com.integ.scripting.nodes.LogicalNode;
import com.integ.scripting.nodes.UnaryNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.scripting.objects.ArrayUtilsObject;
import com.integ.scripting.objects.AssignmentObject;
import com.integ.scripting.objects.BlockObject;
import com.integ.scripting.objects.DateObject;
import com.integ.scripting.objects.DigitalInputObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.PrintObject;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.scripting.objects.RelayOutputObject;
import com.integ.scripting.objects.StringObject;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.io.ByteArrayOutputStream;

public class ParseEngine {
    public boolean Debug = false;
    private final Queue _tokenQueue = new Queue();
    private final TokenStream _tokens = new TokenStream(this._tokenQueue);
    private final BlockObject _root = new BlockObject();

    public void setDebug(boolean shouldDebug) {
        this.Debug = shouldDebug;
        this._tokens.printDebug(true);
    }

    public void parse(String script) throws Exception {
        this._tokens.clear();
        Lexer.parse(this._tokenQueue, script);
        this._root.parse(this);
    }

    public Token currentToken() {
        return this._tokens.currentToken();
    }

    public Token nextToken() {
        return this._tokens.nextToken();
    }

    public Token peekToken() {
        return this._tokens.peekToken();
    }

    public boolean isEmpty() {
        return this._tokens.isEmpty();
    }

    public AbstractNode parseStatement() throws ScriptParserException {
        Token currentToken = this._tokens.getCurrent();
        if (this.Debug) {
            System.out.println(String.format("getStatement(%s)", currentToken.toString()));
        }
        AbstractObject abstractObject = null;
        if (currentToken.checkContent("print")) {
            abstractObject = new PrintObject();
            abstractObject.parse(this);
        } else if (currentToken.checkContent("set")) {
            this.nextToken();
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else if (this.peekToken().checkType(61)) {
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else {
            throw new UnknownTokenException(currentToken);
        }
        if (!this.isEmpty() && !this.nextToken().checkType(59)) {
            throw new UnexpectedTokenException(";", this.currentToken());
        }
        if (!this.isEmpty()) {
            this.nextToken();
        }
        return abstractObject;
    }

    public AbstractNode getObject() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getObject current token: " + this.currentToken());
        }
        return this.getLogical();
    }

    public AbstractNode getLogical() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getLogical current token: " + this.currentToken());
        }
        AbstractNode cNode = this.getComparison();
        if (this.peekToken().checkType(59) || this.peekToken().checkType(44) || this.peekToken().checkType(41) || this.peekToken().checkType(93)) {
            return cNode;
        }
        Token token = this.nextToken();
        if (this.Debug) {
            System.out.println("getLogical operator token: " + token);
        }
        switch (token.type) {
            default: 
        }
        return cNode;
    }

    public AbstractNode getComparison() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getComparison current token: " + this.currentToken());
        }
        AbstractNode eNode = this.getExpression();
        if (this.peekToken().checkType(59) || this.peekToken().checkType(44) || this.peekToken().checkType(41) || this.peekToken().checkType(93)) {
            return eNode;
        }
        Token token = this.nextToken();
        if (this.Debug) {
            System.out.println("getComparison operator token: " + token);
        }
        switch (token.type) {
            default: 
        }
        return eNode;
    }

    private AbstractNode getExpression() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getExpression(): " + this.currentToken());
        }
        AbstractNode t1node = this.getTerm();
        while (this.peekToken().checkType(43) || this.peekToken().checkType(45)) {
            this.nextToken();
            Token token = this.currentToken();
            this.nextToken();
            AbstractNode t2node = this.getTerm();
            t1node = this.createBinaryNode(token, t1node, t2node);
        }
        return t1node;
    }

    private AbstractNode getTerm() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getExpression(): " + this.currentToken());
        }
        AbstractNode f1node = this.getFactor();
        while (this.peekToken().checkType(42) || this.peekToken().checkType(47)) {
            this.nextToken();
            Token token = this.currentToken();
            this.nextToken();
            AbstractNode f2node = this.getFactor();
            f1node = this.createBinaryNode(token, f1node, f2node);
        }
        return f1node;
    }

    public AbstractNode getFactor() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getFactor current token: " + this.currentToken());
        }
        Token currentToken = this.currentToken();
        switch (currentToken.type) {
            case 40: {
                this.nextToken();
                AbstractNode node = this.getExpression();
                if (!this.peekToken().checkType(41)) {
                    throw new UnexpectedTokenException(")", currentToken);
                }
                this.nextToken();
                return node;
            }
            case 45: {
                this.nextToken();
                AbstractNode node = this.getFactor();
                return this.createUnaryNode(node);
            }
            case 4: {
                return new ValueNode(currentToken.content);
            }
            case 16: {
                return new ValueNode(currentToken.content);
            }
            case 3: {
                if (-1 == currentToken.content.indexOf(".")) {
                    return new ValueNode(Integer.valueOf(currentToken.content));
                }
                return new ValueNode(Double.valueOf(currentToken.content));
            }
            case 15: {
                ByteArrayOutputStream baos = new ByteArrayOutputStream();
                baos.write(Integer.parseInt(this.currentToken().content, 16));
                while (this.peekToken().checkType(15)) {
                    this.nextToken();
                    baos.write(Integer.parseInt(this.currentToken().content, 16));
                }
                return new ValueNode(baos.toByteArray());
            }
            case 0: {
                AbstractObject abstractObject = this.getIdentifier();
                return abstractObject.parse(this);
            }
        }
        return null;
    }

    private AbstractObject getIdentifier() throws ScriptParserException {
        if (this.Debug) {
            System.out.println("getIdentifier current token: " + this.currentToken());
        }
        Token currentToken = this.currentToken();
        AbstractObject abstractObject = null;
        abstractObject = currentToken.checkContent("din") ? new DigitalInputObject() : (currentToken.checkContent("rout") ? new RelayOutputObject() : (currentToken.checkContent("iin") ? new FourTwentyInputObject() : (currentToken.checkContent("arrayutils") ? new ArrayUtilsObject() : (currentToken.checkContent("date") ? new DateObject() : (currentToken.checkContent("string") ? new StringObject() : new ReferenceObject())))));
        return abstractObject;
    }

    private AbstractNode createBinaryNode(Token operator, AbstractNode left, AbstractNode right) {
        BinaryNode node = new BinaryNode(operator, left, right);
        if (this.Debug) {
            System.out.println("createBinaryNode(" + operator + ", " + left + ", " + right + ") = " + node);
        }
        return node;
    }

    private AbstractNode createLogicalNode(Token operator, AbstractNode left, AbstractNode right) {
        LogicalNode node = new LogicalNode(operator, left, right);
        if (this.Debug) {
            System.out.println("createLogicalNode(" + operator + ", " + left + ", " + right + ") = " + node);
        }
        return node;
    }

    private AbstractNode createUnaryNode(AbstractNode left) {
        UnaryNode node = new UnaryNode(new Token(45, "0", 0, 0), left);
        if (this.Debug) {
            System.out.println("createUnaryNode(" + left + ") = " + node);
        }
        return node;
    }

    private AbstractNode createValueNode(Number value) {
        ValueNode node = new ValueNode(value);
        if (this.Debug) {
            System.out.println("createValueNode(" + value + ") = " + node);
        }
        return node;
    }

    public void execute(Scope scope) {
        this._root.execute(scope);
    }
}

