/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlpanel;

import com.integ.tasker.TaskerMain;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.externalio.controlpanel.ControlPanel;
import com.integpg.janoslib.logger.AppLog;
import java.io.IOException;
import java.util.Json;

public class PlayAlarmMethod
extends Action {
    public PlayAlarmMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            ControlPanel controlPanel = TaskerMain.getControlPanel();
            if (0 == controlPanel.getPanelCount()) {
                AppLog.info("no control panels detected.  reenumerating now");
                controlPanel = TaskerMain.getControlPanel().enumeratePanels();
            }
            String alarmTypeString = this.getStringParam("AlarmType", taskRuntime);
            System.out.println("AlarmType Param: " + alarmTypeString);
            int volume = this.getIntParam("Volume", taskRuntime);
            System.out.println("Volume Param: " + volume);
            int duration = this.getIntParam("DurationInSeconds", taskRuntime);
            if (Integer.MIN_VALUE == duration) {
                duration = 5;
            }
            System.out.println("DurationInSeconds Param: " + duration);
            int frequency = 82;
            int period = 1000;
            if ("slow".equalsIgnoreCase(alarmTypeString)) {
                period = 1000;
            } else if ("medium".equalsIgnoreCase(alarmTypeString)) {
                period = 500;
            } else if ("fast".equalsIgnoreCase(alarmTypeString)) {
                period = 250;
            } else if ("custom".equalsIgnoreCase(alarmTypeString)) {
                frequency = this.getIntParam("Frequency", taskRuntime);
                if (Integer.MIN_VALUE == frequency) {
                    frequency = 82;
                }
                if (Integer.MIN_VALUE == (period = this.getIntParam("Period", taskRuntime))) {
                    period = 1000;
                }
            }
            controlPanel.soundAlarm((byte)frequency, (byte)0, (short)(period / 2), (short)period, (short)duration, (byte)((double)volume * 2.5));
        }
        catch (Exception ex) {
            throw new IOException("Error setting Control Panel LED channel").initCause(ex);
        }
    }
}

