var app = angular.module('TaskerHelp', []);

app.controller('HelpController', function ($scope, $location, $q, $http, $templateCache) {
    var _this = this;
    _this.order = 'Title';
    _this.search = {};
    _this.search.Category = $location.search()['category'];

    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var locationSearch = $location.search();
            var blockId = locationSearch.blockId;
            if (blockId) {
                scrollTo('#' + blockId);
            }
        }
    });


    
    _this.setOrder = function (order) {
        _this.order = order;
    };

    
    
    _this.getHtml = function (block) {  
        return block.Id + '.html';
    };



    _this.scrollTo = function (block) {
        $location.search('blockId', block.Id);
    };


    _this.Blocks = [
        {
            Id: "action-syntax", Title: "Setting Up Conditional Values", Category: "Syntax", Since: "3.0",
        },
        {
            Id: "logging-syntax", Title: "Setting Up Logger Values", Category: "Syntax", Since: "3.0",
        },
        {
            Id: "other-comment", Title: "Comment", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Description", Type: "Text" },
            ]
        },
        {
            Id: "other-commandline", Title: "Command Line", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Command", Type: "Text" },
            ]
        },
        {
            Id: "other-reboot", Title: "Reboot", Category: "Other Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "other-executetask", Title: "Execute Task", Category: "Other Actions", Since: "3.0", Arguments: [
                { Name: "Task", Type: "Text" },
            ]
        },
        {
            Id: "other-canceltask", Title: "Cancel Task", Category: "Other Actions", Since: "4.1", Arguments: [
                {Name: "Task Name", Type: "Text"},
            ]
        },
        {
            Id: "other-executescript", Title: "Execute Script Task", Category: "Other Actions", Since: "3.3", Arguments: [
                {Name: "Script Box", Type: "Text"},
            ]
        },
        {
            Id: "other-useralert", Title: "User Alert", Category: "Other Actions", Since: "3.5", Arguments: [
                {Name: "User Alert", Type: "Text"},
            ]
        },
        {
            Id: "other-deletefile", Title: "Delete File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
            ]
        },
        {
            Id: "other-prependfile", Title: "Prepend File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "Added Text", Type: "Text" },
            ]
        },
        {
            Id: "other-copyfile", Title: "Copy File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "other-movefile", Title: "Move File", Category: "Other Actions", Since: "3.3", Arguments: [
                { Name: "File Name", Type: "Text" },
                { Name: "File Destination", Type: "Text" },
            ]
        },
        {
            Id: "timing-sleep", Title: "Sleep", Category: "Timing Actions", Since: "3.0", Arguments: [
                { Name: "Duration", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-softinputinvert", Title: "Soft Input Invert", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-setinputcounter", Title: "Set Input Counter", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayinputs-resetinputusagemeter", Title: "Reset Input Usage Meter", Category: "Input Actions", Since: "3.2", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-closerelay", Title: "Close Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-openrelay", Title: "Open Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-setrelay", Title: "Set Relay State", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "State", Type: "HIGH or LOW" },
            ]
        },
        {
            Id: "relayoutputs-pulserelay", Title: "Pulse Relay", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "relayoutputs-setrelays", Title: "Set Relay States", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channels", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
            ]
        },
        {
            Id: "relayoutputs-pulserelays", Title: "Pulse Relay States", Category: "Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "States", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" }
            ]
        },
        {
            Id: "analogoutputs-set10vpercentage", Title: "Set 10v Percentage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set10vvoltage", Title: "Set 10v Voltage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Voltage", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "analogoutputs-set420mapercentage", Title: "Set 4-20ma Percentage", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "analogoutputs-set420maamps", Title: "Set 4-20ma Amps", Category: "Analog Output Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Amps", Type: "Number Block, can use decimals" },
            ]
        },
        {
            Id: "controlstructures-ifblock", Title: "If Block", Category: "Control Structure Actions", Since: "3.0", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-ifelseblock", Title: "If Else Block", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "If Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-loop", Title: "Loop", Category: "Control Structure Actions", Since: "3.0", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
                { Name: "Start Value of Length", Type: "Number Block" },
                { Name: "End Value of Length", Type: "Number Block" },
            ]
        },
        {
            Id: "controlstructures-whileloop", Title: "While Loop", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "Loop Variable", Type: "Text" },
            ]
        },
        {
            Id: "controlstructures-setvariable", Title: "Set Variable", Category: "Control Structure Actions", Since: "3.1", Arguments: [
                { Name: "Variable", Type: "Text" },
                { Name: "Value", Type: "Text" },
            ]
        },
        {
            Id: "controlpanel-setled", Title: "Set LED", Category: "Control Panel Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "LED State", Type: "Drop-Down option" },
            ]
        },
        {
            Id: "controlpanel-playalarm", Title: "Play Alarm", Category: "Control Panel Actions", Since: "3.0", Arguments: [
                { Name: "Alarm Rate", Type: "Drop-Down option" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
                { Name: "Volume Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "controlpanel-silencealarm", Title: "Silence Alarm", Category: "Control Panel Actions", Since: "3.0", Arguments: [
            ]
        },
        {
            Id: "lighting-setdimmerchannel", Title: "Set LED Dimmer Channel", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-setdimmerrgb", Title: "Set LED Dimmer RGB", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
            ]
        },
        {
            Id: "lighting-fadedimmerchannel", Title: "Fade LED Dimmer Channel", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Channel", Type: "Number Block" },
                { Name: "Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "lighting-fadedimmerrgb", Title: "Fade LED Dimmer RGB", Category: "Lighting Actions", Since: "3.0", Arguments: [
                { Name: "Dimmer being set", Type: "Number Block" },
                { Name: "Red Percentage", Type: "Number Block" },
                { Name: "Green Percentage", Type: "Number Block" },
                { Name: "Blue Percentage", Type: "Number Block" },
                { Name: "Duration", Type: "Seconds, can use decimals" },
            ]
        },
        {
            Id: "logging-logentry", Title: "Log Entry", Category: "Logging Actions", Since: "3.0", Arguments: [
                { Name: "Text to be Logged", Type: "Text" },
                { Name: "File Path", Type: "Text" },
            ]
        },
        {
            Id: "logging-logprofile", Title: "Log Profile", Category: "Logging Actions", Since: "3.0", Arguments: [
                { Name: "Log Profile being called", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpsend", Title: "Tcp Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpreceive", Title: "Tcp Receive", Category: "Network Actions", Since: "3.3", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-tcpclose", Title: "Tcp Close", Category: "Network Actions", Since: "3.3", Arguments: [
                { Name: "Device", Type: "Drop-Down Select" },
                { Name: "Info being sent", Type: "Text" },
            ]
        },
        {
            Id: "network-emailsend", Title: "Email Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Recipient Email", Type: "Text" },
                { Name: "Email's Subject", Type: "Text" },
                { Name: "Email's Attachment", Type: "Text" },
                { Name: "Email's Message", Type: "Text" },
            ]
        },
        {
            Id: "network-emailprofilesend", Title: "Email Profile Send", Category: "Network Actions", Since: "3.0", Arguments: [
                { Name: "Email Profile", Type: "Text" },
            ]
        },
        {
            Id: "network-snmptrap", Title: "SNMP Trap", Category: "Network Actions", Since: "3.1", Arguments: [
                { Name: "OID", Type: "Number Block" },
                { Name: "Data", Type: "Text" },
                { Name: "Device", Type: "Drop-Down Select" },
            ]
        },
        {
            Id: "network-snmpset", Title: "SNMP Set", Category: "Network Actions", Since: "4.1", Arguments: [
                {Name: "OID", Type: "Number Block"},
                {Name: "Data", Type: "Text"},
                {Name: "Value", Type: "Drop-Down Select"},
                {Name: "Device", Type: "Drop-Down Select"}
            ]
        },
        {
            Id: "network-httprequest", Title: "HTTP Request", Category: "Network Actions", Since: "5.0", Arguments: [
                {Name: "URL Address", Type: "Text"},
            ]
        },
        {
            Id: "network-httppost", Title: "HTTP Post", Category: "Network Actions", Since: "3.8", Arguments: [
                {Name: "URL Address", Type: "Text"},
                {Name: "Data", Type: "Text"}
            ]
        },
    ];

    _this.getCategories = function () {
        return ['Task Actions'];
    };

});

