/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http;

import com.integpg.janoslib.debug.ThreadElapsed;
import com.integpg.janoslib.http.HttpRequest;
import com.integpg.janoslib.logger.AppLog;
import java.io.DataInputStream;
import java.io.IOException;
import java.util.Hashtable;

public class HttpResponse {
    private final HttpRequest _httpRequest;
    private final Hashtable<String, String> _headers = new Hashtable();
    private int _responseCode;
    private String _responseString;
    private String _data;
    private int _length = 0;

    HttpResponse(HttpRequest httpRequest) {
        this._httpRequest = httpRequest;
    }

    public int getResponseCode() {
        return this._responseCode;
    }

    public String getResponseString() {
        return this._responseString;
    }

    public String getHeader(String name) {
        return this._headers.get(name);
    }

    public String getData() {
        return this._data;
    }

    public int getResponseLength() {
        return this._length;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processResponse() {
        DataInputStream is = null;
        try {
            String transferEncoding;
            is = new DataInputStream(this._httpRequest.getInputStream());
            String header = is.readLine();
            this._length += header.length() + 2;
            this._responseCode = Integer.parseInt(header.substring(9, 12));
            System.out.println(ThreadElapsed.getElapsed() + "responseCode: " + this._responseCode);
            this._responseString = header.substring(13);
            System.out.println(ThreadElapsed.getElapsed() + "responseString: " + this._responseString);
            System.out.println(ThreadElapsed.getElapsed() + "read headers");
            while (!"".equals(header = is.readLine())) {
                this._length += header.length() + 2;
                int equalsPos = header.indexOf(":");
                if (-1 >= equalsPos) continue;
                String name = header.substring(0, equalsPos);
                String value = header.substring(equalsPos + 1);
                this._headers.put(name, value);
            }
            boolean isChunked = this._headers.containsKey("Transfer-Encoding");
            if (isChunked && null != (transferEncoding = this._headers.get("Transfer-Encoding"))) {
                transferEncoding = transferEncoding.trim();
                System.out.println("transferEncoding: " + transferEncoding);
                System.out.println("isChunked: " + (isChunked &= "chunked".equalsIgnoreCase(transferEncoding)));
            }
            if (isChunked) {
                this.readChunkedBody();
            } else {
                this.readBody();
            }
            System.out.println(ThreadElapsed.getElapsed());
        }
        catch (IOException ex) {
            AppLog.error("Error reading response", ex);
            try {
                this._httpRequest.close();
            }
            catch (IOException ex2) {
                AppLog.error("Error closing connection", ex2);
            }
        }
    }

    private void readChunkedBody() throws IOException {
        DataInputStream is = new DataInputStream(this._httpRequest.getInputStream());
        StringBuilder sb = new StringBuilder(4096);
        byte[] inBytes = new byte[4096];
        StringBuilder debug = new StringBuilder(4096);
        debug.append("read chunked body\r\n");
        try {
            while (true) {
                int bytesRead;
                String line = is.readLine();
                this._length += line.length() + 2;
                int amountOfDataToFollow = Integer.parseInt(line, 16);
                debug.append("amount of data to follow " + line + " = " + amountOfDataToFollow + "\r\n");
                if (0 == amountOfDataToFollow) {
                    break;
                }
                while ((bytesRead = is.read(inBytes, 0, Math.min(inBytes.length, amountOfDataToFollow))) > 0) {
                    this._length += bytesRead;
                    sb.append(new String(inBytes, 0, bytesRead));
                    amountOfDataToFollow -= bytesRead;
                }
                line = is.readLine();
                this._length += line.length() + 2;
            }
        }
        catch (Exception ex) {
            this._httpRequest.getLogger().warn("incomplete read.\r\n" + sb.toString());
            this._httpRequest.getLogger().info(debug.toString());
            throw ex;
        }
        finally {
            this._data = sb.toString();
        }
    }

    private void readBody() throws IOException {
        DataInputStream is = new DataInputStream(this._httpRequest.getInputStream());
        System.out.println(ThreadElapsed.getElapsed() + "read body");
        StringBuilder sb = new StringBuilder(4096);
        byte[] inBytes = new byte[4096];
        try {
            while (is.available() > 0) {
                int bytesRead = is.read(inBytes, 0, inBytes.length);
                this._length += bytesRead;
                sb.append(new String(inBytes, 0, bytesRead));
            }
        }
        catch (Exception ex) {
            this._httpRequest.getLogger().warn("incomplete read.\r\n" + sb.toString());
            throw ex;
        }
        finally {
            this._data = sb.toString();
        }
    }
}

