/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.Device;
import java.util.Enumeration;
import java.util.Hashtable;

public class DeviceCollection {
    public static final DeviceCollection GLOBAL = new DeviceCollection();
    private final Hashtable<String, Device> _collection = new Hashtable();

    public Hashtable<String, Device> getDevices() {
        return this._collection.clone();
    }

    public void clear() {
        if (this == GLOBAL) {
            return;
        }
        Enumeration<String> e = this._collection.keys();
        while (e.hasMoreElements()) {
            String deviceGUID = e.nextElement();
            this._collection.remove(deviceGUID);
            DeviceCollection.GLOBAL._collection.remove(deviceGUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void put(Device device) {
        if (this == GLOBAL) {
            return;
        }
        Hashtable<String, Device> hashtable = this._collection;
        synchronized (hashtable) {
            this._collection.put(device.GUID.toLowerCase(), device);
            DeviceCollection.GLOBAL._collection.put(device.GUID.toLowerCase(), device);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean containsDeviceGUID(String deviceGUID) {
        Hashtable<String, Device> hashtable = this._collection;
        synchronized (hashtable) {
            deviceGUID = deviceGUID.toLowerCase();
            return this._collection.containsKey(deviceGUID);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Device getByDeviceGUID(String deviceGUID) {
        Hashtable<String, Device> hashtable = this._collection;
        synchronized (hashtable) {
            deviceGUID = deviceGUID.toLowerCase();
            if (!this._collection.containsKey(deviceGUID)) {
                throw new RuntimeException(String.format("%s device is not found", deviceGUID));
            }
            return this._collection.get(deviceGUID);
        }
    }
}

