/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.threading;

import com.integpg.janoslib.collections.Queue;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.threading.ThreadWorker;

public class ThreadPool {
    public static final Logger LOG = Logger.getLogger("/temp/" + Application.getAppName() + "_threading.log").enableLogThreadName();
    private static final Object THREAD_POOL_LOCK = new Object();
    private static final int THREAD_POOL_SIZE = 10;
    private static ThreadWorker[] _threadPool = new ThreadWorker[10];
    private static final Queue _tasks = new Queue();
    private static int _threadWorkerCount = 0;
    private static boolean _cancelled = false;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean execute(Runnable task) {
        ThreadWorker threadWorker = null;
        Object object = THREAD_POOL_LOCK;
        synchronized (object) {
            if (_cancelled) {
                throw new RuntimeException("ThreadPool has been cancelled");
            }
            for (int i = 0; i < _threadWorkerCount; ++i) {
                if (null == _threadPool[i]) continue;
                if (_threadPool[i].isDone()) {
                    ThreadPool._threadPool[i] = null;
                    --_threadWorkerCount;
                    continue;
                }
                if (_threadPool[i].isBusy()) continue;
                threadWorker = _threadPool[i];
                break;
            }
            if (threadWorker == null && _threadWorkerCount < 10) {
                threadWorker = new ThreadWorker(_threadWorkerCount);
                threadWorker.start();
                ThreadPool._threadPool[ThreadPool._threadWorkerCount++] = threadWorker;
                String s = String.format("ThreadWorker-%d", _threadWorkerCount);
                AppLog.info(String.format("%s started", s));
                LOG.info(String.format("%s started", s));
            }
        }
        if (threadWorker != null) {
            threadWorker.setTask(task);
            return true;
        }
        String s = String.format("no ThreadWorker available.  queue %s task", task.toString());
        AppLog.info(s);
        LOG.info(s);
        Queue queue = _tasks;
        synchronized (queue) {
            _tasks.enqueue(task);
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void threadWorkerAvailable(ThreadWorker threadWorker) {
        Runnable r = null;
        Queue queue = _tasks;
        synchronized (queue) {
            if (!_tasks.isEmpty()) {
                r = (Runnable)_tasks.dequeue();
            }
        }
        if (r != null) {
            LOG.info(threadWorker.getName() + " execute queued task");
            threadWorker.setTask(r);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void cancel() {
        Object object = THREAD_POOL_LOCK;
        synchronized (object) {
            _cancelled = true;
            Queue queue = _tasks;
            synchronized (queue) {
                while (!_tasks.isEmpty()) {
                    _tasks.dequeue();
                }
            }
            for (int i = 0; i < _threadWorkerCount; ++i) {
                _threadPool[i].cancel();
            }
        }
    }

    public static void setThreadWorkerLimit(int limit) {
        ThreadPool.cancel();
        _threadPool = new ThreadWorker[limit];
        _cancelled = false;
    }
}

