function parseNetworkAction(json) {
    var method = json.Method;

    switch (method) {
        case 'TcpSend':
            return new TcpSend();

        case 'TcpRecv':
            return new TcpRecv();

        case 'TcpClose':
            return new TcpClose();

        case 'EmailSend':
            return new EmailEntry();

        case 'EmailProfileSend':
            return new EmailProfile();

        case 'SNMPTrap':
            return new SNMPTrap();

        case 'SNMPSet':
            return new SNMPSet();

        case 'HTTPGet':
            return new HTTPGet();

        case 'HTTPPost':
            return new HTTPPost();

        case 'MQTTPublish':
            return new MQTTPublish();

        default:
            throw new Error('Unknown Network Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class NetworkAction extends Action {
    constructor() {
        super();
        this.Type = 'Network';
        this.Method = 'void';
        this.Params = {};
    }
}



class TcpSend extends NetworkAction {
    constructor(message) {
        super();
        this.Method = 'TcpSend';
        this.Params.Message = message;
    }

    editTemplate() {
        var template = 'Tcp Send to ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' the following message' +
            ' <input name="tcpsend-message" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped cahracters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />\r\n' +
            ' ';
        return template;
    }
}



class TcpRecv extends NetworkAction {
    constructor() {
        super();
        this.Method = 'TcpRecv';
    }

    editTemplate() {
        var template = 'Tcp Receive from ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' ';
        return template;
    }
}



class TcpClose extends NetworkAction {
    constructor() {
        super();
        this.Method = 'TcpClose';
    }

    editTemplate() {
        var template = 'Tcp Close ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' ';
        return template;
    }
}



class EmailEntry extends NetworkAction {
    constructor(toRecipient, subject, body) {
        super();
        this.Method = 'EmailSend';
        this.Params.ToRecipient = toRecipient;
        this.Params.Subject = subject;
        this.Params.Body = body;
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            'Email To <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ToRecipient" data-toggle="tooltip" title="Recipient Address" style="margin-bottom:8px; width:600px;">' +
            'Subject <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Subject" data-toggle="tooltip" title="Subject" style="margin-bottom:8px; width:600px;">' +
            'Attachment <input name="' + guid() + '" type="text" class="form-control" ng-model="action.Params.Attachment" data-toggle="tooltip" title="Attachment" style="margin-bottom:8px; width:600px;">' +
            'Message <textarea name="' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Body" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}



class EmailProfile extends NetworkAction {
    constructor(profileName) {
        super();
        this.Method = 'EmailProfileSend';
        this.Params.ProfileName = profileName;
    }

    editTemplate() {
        var template = 'Send Email Profile for <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ProfileName">';
        return template;
    }
}



class SNMPTrap extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SNMPTrap';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send SNMP Trap for OID ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.OID" style="width: 225px;"> Data ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Message" style="width: 225px;"> to ' +
            '<select name="snmptrap-device-' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getSNMPDevices()"' +
            '  data-toggle="tooltip" title="Select a SNMP Device">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n';
        return template;
    }
}



class SNMPSet extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SNMPSet';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send SNMP Set for OID ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.OID" style="width: 225px;"> Data ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Message" style="width: 225px;"> to ' +
            '<select name="snmpset-type-' + guid() + '" class="form-control" ng-model="action.Params.Type"  ng-options="type for type in controller.getSNMPTypes()" title="Select the OID type">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n' +
            '<select name="snmpset-device-' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getSNMPDevices()"' +
            '  data-toggle="tooltip" title="Select a SNMP Device">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n';
        return template;
    }
}



class HTTPGet extends NetworkAction {
    constructor() {
        super();
        this.Method = 'HTTPGet';
        this.Params = {};
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            'Send HTTP Request to ' +
            '<input name="url-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Url" style="width: 300px;"> the following data ' +
            '</div>';
        return template;
    }
}



class HTTPPost extends NetworkAction {
    constructor() {
        super();
        this.Method = 'HTTPPost';
        this.Params = {};
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            'Send HTTP Post to ' +
            '<input name="url-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Url" style="width: 300px;"> the following data ' +
            '<textarea name="data-' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Data" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}



class MQTTPublish extends NetworkAction {
    constructor() {
        super();
        this.Method = 'MQTTPublish';
        this.Params = {};
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            'Publish the MQTT Topic ' +
            '<input name="topic-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Topic" style="width: 300px;"> the following data ' +
            '<textarea name="payload-' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Payload" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}