/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.system.Application;
import com.integpg.janoslib.utils.RegistryUtils;
import java.io.File;

public class Config {
    private static final String APPDATA_ROOT = "AppData/" + Application.getAppName();
    public static final File TASKER_DIRECTORY = new File("/flash/tasker/");
    public static final File TASKER_LOGGING_DIRECTORY = new File("/flash/tasker/logging/");
    public static final File TASKER_WORKSPACE_DIRECTORY = new File("/flash/tasker/workspaces/");

    static void init() {
        Config.initializeDirectoryStructure();
        Config.getAsciiCommandServerPort();
        Config.getAsciiCommandSerialPort();
        Config.getAsciiCommandSerialPortSettings();
        Config.getWebServerPort();
    }

    private static void initializeDirectoryStructure() {
        if (!TASKER_DIRECTORY.exists()) {
            AppLog.info("create " + TASKER_DIRECTORY.getPath());
            TASKER_DIRECTORY.mkdir();
        }
        if (!TASKER_LOGGING_DIRECTORY.exists()) {
            AppLog.info("create " + TASKER_LOGGING_DIRECTORY.getPath());
            TASKER_LOGGING_DIRECTORY.mkdir();
        }
        if (!TASKER_WORKSPACE_DIRECTORY.exists()) {
            AppLog.info("create " + TASKER_WORKSPACE_DIRECTORY.getPath());
            TASKER_WORKSPACE_DIRECTORY.mkdir();
        }
    }

    public static int getAsciiCommandServerPort() {
        return RegistryUtils.getRegistryKey(String.format("%s/AsciiCommandServerPort", APPDATA_ROOT), 9210);
    }

    static String getAsciiCommandSerialPort() {
        return RegistryUtils.getRegistryKey(String.format("%s/AsciiCommandSerialPort", APPDATA_ROOT), "none");
    }

    static String[] getAsciiCommandSerialPortSettings() {
        return RegistryUtils.getRegistryKeys(String.format("%s/AsciiCommandSerialPortSettings", APPDATA_ROOT), "9600,8,1,0");
    }

    static int getWebServerPort() {
        return RegistryUtils.getRegistryKey(String.format("%s/WebServerPort", APPDATA_ROOT), -1);
    }
}

