/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.OSCDevice;
import com.integ.tasker.devices.osc.OSCMessage;
import com.integ.tasker.lexer.Lexer;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.janoslib.collections.Queue;
import com.integpg.janoslib.utils.HexUtils;
import java.io.IOException;
import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.net.SocketException;
import java.util.Json;

public class OSCSendMethod
extends Action {
    public OSCSendMethod(Task parentTask, Json json) {
        super(parentTask, json);
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        if (!(device instanceof OSCDevice)) {
            throw new RuntimeException("Device found for " + deviceGuid + " is not an OSC Device");
        }
        String address = this._paramsJson.getString("address");
        String dataArray = this._paramsJson.getString("data_array");
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"SNMPSet");
        deviceActionJson.put("name", (Object)device.Name);
        deviceActionJson.put("address", (Object)address);
        deviceActionJson.put("data_array", (Object)dataArray);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            System.out.println(this.toString());
            String address = this._paramsJson.getString("address");
            String dataArray = this._paramsJson.getString("data_array");
            OSCMessage message = new OSCMessage(address);
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, dataArray);
            for (int i = 0; i < tokenQueue.size(); ++i) {
                boolean isFloat;
                Token token = tokenQueue.elementAt(i);
                System.out.println(String.format("   token %d: %s", i, token.toString()));
                if (token.checkType(4)) {
                    message.addString(token.content);
                    continue;
                }
                if (!token.checkType(3)) continue;
                boolean bl = isFloat = -1 != token.content.indexOf(46);
                if (isFloat) {
                    message.addFloat(Float.valueOf(token.content).floatValue());
                    continue;
                }
                message.addInteger(Integer.valueOf(token.content));
            }
            byte[] messageBytes = message.getBytes();
            System.out.println(HexUtils.hexDump(messageBytes));
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            if (null == deviceGuid || "".equals(deviceGuid)) {
                throw new RuntimeException("No device was selected for this OSC Send action");
            }
            DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
            if (!(device instanceof OSCDevice)) {
                throw new RuntimeException("Device found for " + deviceGuid + " is not an OSC Device");
            }
            OSCDevice oscDevice = (OSCDevice)device;
            System.out.println("sending OSC");
            DatagramSocket clientSocket = null;
            try {
                clientSocket = new DatagramSocket();
                DatagramPacket sendPacket = new DatagramPacket(messageBytes, messageBytes.length, InetAddress.getByName(oscDevice.getIpAddress()), oscDevice.getPort());
                clientSocket.send(sendPacket);
            }
            catch (SocketException ex) {
                ex.printStackTrace();
            }
            catch (IOException ex) {
                ex.printStackTrace();
            }
            finally {
                if (null != clientSocket) {
                    clientSocket.close();
                }
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing OSC Send").initCause(ex);
        }
    }

    public String toString() {
        String address = this._paramsJson.getString("address");
        String dataArray = this._paramsJson.getString("data_array");
        return String.format("OSC Device: %s %s", address, dataArray);
    }
}

