/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.controlstructures;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import java.util.Json;

public class IfElseMethod
extends Action {
    private final String _conditional;
    private final Action[] _actions;
    private final Action[] _elseActions;

    public IfElseMethod(Task parentTask, Json json) {
        super(parentTask, json);
        this._conditional = this._paramsJson.getString("Conditional");
        this._actions = super.getActions("Actions");
        this._elseActions = super.getActions("ElseActions");
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        long start = System.currentTimeMillis();
        boolean _debug_ = taskRuntime.Scope.isDebug();
        try {
            ExpressionEngine _expressionEngine = new ExpressionEngine();
            _expressionEngine.setDebug(_debug_);
            _expressionEngine.parse(this._conditional);
            Object resultObject = _expressionEngine.execute(taskRuntime.Scope);
            if (_debug_) {
                System.out.println("resultObject = " + resultObject);
            }
            if (((Boolean)resultObject).booleanValue()) {
                this.executeActions(this._actions, taskRuntime);
            } else {
                this.executeActions(this._elseActions, taskRuntime);
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing If Else Conditional: " + this._conditional).initCause(ex);
        }
        long elapsed = System.currentTimeMillis() - start;
        if (_debug_) {
            System.out.println("if else then elapsed: " + elapsed);
        }
    }
}

