/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.BinaryNode;
import com.integ.scripting.nodes.LogicalNode;
import com.integ.scripting.nodes.UnaryNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObject;
import com.integ.scripting.objects.ArrayUtilsObject;
import com.integ.scripting.objects.AssignmentObject;
import com.integ.scripting.objects.BlockObject;
import com.integ.scripting.objects.ControlPanelLedObject;
import com.integ.scripting.objects.DateObject;
import com.integ.scripting.objects.DigitalInputObject;
import com.integ.scripting.objects.DoubleObject;
import com.integ.scripting.objects.EnvironObject;
import com.integ.scripting.objects.FileObject;
import com.integ.scripting.objects.FourTwentyInputObject;
import com.integ.scripting.objects.FourTwentyOutputObject;
import com.integ.scripting.objects.IntObject;
import com.integ.scripting.objects.MathObject;
import com.integ.scripting.objects.PrintObject;
import com.integ.scripting.objects.ReferenceObject;
import com.integ.scripting.objects.RegistryObject;
import com.integ.scripting.objects.RelayOutputObject;
import com.integ.scripting.objects.StringObject;
import com.integ.scripting.objects.TempProbeObject;
import com.integ.scripting.objects.TenVoltInputObject;
import com.integ.scripting.objects.TenVoltOutputObject;
import com.integ.scripting.objects.TimeObject;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import java.util.Stack;

public class ExpressionEngine {
    private boolean Debug = false;
    private final Queue<Token> _tokenQueue = new Queue();
    private final TokenStream _tokens = new TokenStream(this._tokenQueue);
    private final BlockObject _root = new BlockObject();
    private String _script;

    public boolean shouldDebug() {
        return this.Debug;
    }

    public void setDebug(boolean shouldDebug) {
        this.Debug = shouldDebug;
        this._tokens.printDebug(shouldDebug);
    }

    public void parse(String script) throws Exception {
        this._script = script;
        this._tokens.clear();
        Lexer.setDebug(this.Debug);
        Lexer.parse(this._tokenQueue, script);
        if (this.Debug) {
            for (int i = 0; i < this._tokenQueue.size(); ++i) {
                Token token = this._tokenQueue.elementAt(i);
                System.out.println(String.format("   token %d: %s", i, token.toString()));
            }
        }
        this._root.parse(this);
    }

    public Token currentToken() {
        return this._tokens.currentToken();
    }

    public Token nextToken() {
        Token nextToken = this._tokens.nextToken();
        if (this.Debug) {
            System.out.println(String.format("   next token: %s", nextToken.toString()));
        }
        return nextToken;
    }

    public Token peekToken() {
        Token peekToken = this._tokens.peekToken();
        if (this.Debug) {
            if (null != peekToken) {
                System.out.println(String.format("   peek token: %s", peekToken.toString()));
            } else {
                System.out.println("   peek token: null");
            }
        }
        return peekToken;
    }

    public boolean isEmpty() {
        return this._tokens.isEmpty();
    }

    public AbstractNode parseStatement() throws ScriptParserException {
        Token currentToken = this._tokens.getCurrent();
        if (this.Debug) {
            System.out.println(String.format("getStatement(%s)", currentToken.toString()));
        }
        AbstractObject abstractObject = null;
        if (currentToken.checkContent("print")) {
            abstractObject = new PrintObject();
            abstractObject.parse(this);
        } else if (currentToken.checkContent("set")) {
            this.nextToken();
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else if (!this._tokens.isEmpty() && this.peekToken().checkType(61)) {
            abstractObject = new AssignmentObject();
            abstractObject.parse(this);
        } else {
            return this.getObject();
        }
        if (!this.isEmpty() && !this.nextToken().checkType(59)) {
            throw new UnexpectedTokenException(";", this.currentToken());
        }
        if (!this.isEmpty()) {
            this.nextToken();
        }
        return abstractObject;
    }

    private void printStacks(Stack<AbstractNode> operandStack, Stack<Token> operatorStack) {
        int i;
        System.out.println("  operands: ");
        for (i = 0; i < operandStack.size(); ++i) {
            AbstractNode operand = (AbstractNode)operandStack.elementAt(i);
            System.out.println("    " + operand);
        }
        System.out.println("  operators: ");
        for (i = 0; i < operatorStack.size(); ++i) {
            Token operator = (Token)operatorStack.elementAt(i);
            System.out.println("    " + operator);
        }
    }

    public AbstractNode getObject() throws ScriptParserException {
        Token operator;
        Stack<AbstractNode> operandStack = new Stack<AbstractNode>();
        Stack<Token> operatorStack = new Stack<Token>();
        while (true) {
            Token peekToken;
            Token token = this.currentToken();
            if (this.Debug) {
                System.out.println("token = " + token);
            }
            if (token.checkType(3)) {
                if (this.Debug) {
                    System.out.println("push operand " + token);
                }
                if (-1 == token.content.indexOf(".")) {
                    operandStack.push(new ValueNode(Integer.valueOf(token.content)));
                } else {
                    operandStack.push(new ValueNode(Double.valueOf(token.content)));
                }
                if (this.Debug) {
                    this.printStacks(operandStack, operatorStack);
                }
            } else if (token.checkType(16) || token.checkType(4)) {
                operandStack.push(new ValueNode(token.content));
            } else if (token.checkType(0)) {
                AbstractObject identifierNode = this.getIdentifier();
                if (this.Debug) {
                    System.out.println("identifierNode = " + identifierNode);
                }
                if (null != identifierNode) {
                    identifierNode.parse(this);
                }
                if (this.Debug) {
                    System.out.println("push operand " + identifierNode);
                }
                operandStack.push(identifierNode);
                if (this.Debug) {
                    this.printStacks(operandStack, operatorStack);
                }
            } else {
                Token lastOperator = null;
                if (0 < operatorStack.size()) {
                    lastOperator = (Token)operatorStack.peek();
                }
                if (this.Debug) {
                    System.out.println("lastOperator = " + lastOperator);
                }
                if (operatorStack.empty() || !token.checkType(41) && (null == lastOperator || lastOperator.checkType(40) || this.checkPrecedence(token) < this.checkPrecedence(lastOperator))) {
                    if (this.Debug) {
                        System.out.println("push operator " + token);
                    }
                    operatorStack.push(token);
                    if (this.Debug) {
                        this.printStacks(operandStack, operatorStack);
                    }
                } else {
                    do {
                        AbstractNode right = operandStack.pop();
                        if (this.Debug) {
                            System.out.println("pop right operand " + right);
                        }
                        AbstractNode left = operandStack.pop();
                        if (this.Debug) {
                            System.out.println("pop left operand " + left);
                        }
                        operator = operatorStack.pop();
                        if (this.Debug) {
                            System.out.println("pop operator " + operator);
                        }
                        AbstractNode node = null;
                        if (operator.checkType(43) || operator.checkType(45) || operator.checkType(42) || operator.checkType(47)) {
                            node = this.createBinaryNode(operator, left, right);
                        } else if (operator.checkType(11) || operator.checkType(12) || operator.checkType(60) || operator.checkType(14) || operator.checkType(62) || operator.checkType(13) || operator.checkType(10) || operator.checkType(9)) {
                            node = this.createLogicalNode(operator, left, right);
                        }
                        if (this.Debug) {
                            System.out.println("push operand " + node);
                        }
                        operandStack.push(node);
                        if (!this.Debug) continue;
                        this.printStacks(operandStack, operatorStack);
                    } while (token.checkType(41) && !operatorStack.peek().checkType(40));
                    if (!token.checkType(41)) {
                        if (this.Debug) {
                            System.out.println("push operator " + token);
                        }
                        operatorStack.push(token);
                        if (this.Debug) {
                            this.printStacks(operandStack, operatorStack);
                        }
                    } else if (operatorStack.peek().checkType(40)) {
                        operatorStack.pop();
                    }
                }
            }
            if (this._tokens.isEmpty() || (peekToken = this._tokens.peekToken()).checkType(93) || peekToken.checkType(44)) break;
            boolean leftParenFound = false;
            if (peekToken.checkType(41)) {
                for (int i = 0; i < operatorStack.size(); ++i) {
                    Token t = (Token)operatorStack.elementAt(i);
                    if (!t.checkType(40)) continue;
                    leftParenFound = true;
                    break;
                }
                if (!leftParenFound) {
                    if (!this.Debug) break;
                    System.out.println("lparen not found.  exiting");
                    break;
                }
            }
            this.nextToken();
        }
        if (this.Debug) {
            System.out.println("empty the operator stack");
        }
        while (!operatorStack.empty()) {
            AbstractNode right = operandStack.pop();
            if (this.Debug) {
                System.out.println("pop right operand " + right);
            }
            AbstractNode left = operandStack.pop();
            if (this.Debug) {
                System.out.println("pop left operand " + left);
            }
            operator = operatorStack.pop();
            if (this.Debug) {
                System.out.println("pop operator " + operator);
            }
            AbstractNode node = null;
            if (operator.checkType(43) || operator.checkType(45) || operator.checkType(42) || operator.checkType(47)) {
                node = this.createBinaryNode(operator, left, right);
            } else if (operator.checkType(11) || operator.checkType(12) || operator.checkType(60) || operator.checkType(14) || operator.checkType(62) || operator.checkType(13) || operator.checkType(10) || operator.checkType(9)) {
                node = this.createLogicalNode(operator, left, right);
            }
            if (this.Debug) {
                System.out.println("push operand " + node);
            }
            operandStack.push(node);
            if (!this.Debug) continue;
            this.printStacks(operandStack, operatorStack);
        }
        if (this.Debug) {
            System.out.println(" operandStack.size(): " + operandStack.size());
        }
        if (0 < operatorStack.size()) {
            return operandStack.pop();
        }
        return operandStack.pop();
    }

    private int checkPrecedence(Token token) {
        switch (token.type) {
            case 40: 
            case 41: 
            case 91: 
            case 93: {
                return 1;
            }
            case 42: 
            case 47: {
                return 3;
            }
            case 43: 
            case 45: {
                return 4;
            }
            case 13: 
            case 14: 
            case 60: 
            case 62: {
                return 6;
            }
            case 11: 
            case 12: {
                return 7;
            }
            case 10: {
                return 11;
            }
            case 9: {
                return 12;
            }
        }
        return 100;
    }

    private AbstractObject getIdentifier() throws ScriptParserException {
        Token currentToken = this.currentToken();
        if (this.Debug) {
            System.out.println(String.format("getIdentifier(): %s", this.currentToken().toString()));
        }
        AbstractObject abstractObject = null;
        abstractObject = currentToken.checkContent("din") ? new DigitalInputObject() : (currentToken.checkContent("rout") ? new RelayOutputObject() : (currentToken.checkContent("iin") ? new FourTwentyInputObject() : (currentToken.checkContent("iout") ? new FourTwentyOutputObject() : (currentToken.checkContent("vin") ? new TenVoltInputObject() : (currentToken.checkContent("vout") ? new TenVoltOutputObject() : (currentToken.checkContent("fpled") ? new ControlPanelLedObject() : (currentToken.checkContent("arrayutils") ? new ArrayUtilsObject() : (currentToken.checkContent("date") ? new DateObject() : (currentToken.checkContent("file") ? new FileObject() : (currentToken.checkContent("time") ? new TimeObject() : (currentToken.checkContent("string") ? new StringObject() : (currentToken.checkContent("temp") ? new TempProbeObject() : (currentToken.checkContent("env") ? new EnvironObject() : (currentToken.checkContent("reg") || currentToken.checkContent("registry") ? new RegistryObject() : (currentToken.checkContent("math") ? new MathObject() : (currentToken.checkContent("int") ? new IntObject() : (currentToken.checkContent("double") ? new DoubleObject() : new ReferenceObject())))))))))))))))));
        return abstractObject;
    }

    private AbstractNode createBinaryNode(Token operator, AbstractNode left, AbstractNode right) {
        BinaryNode node = new BinaryNode(operator, left, right);
        if (this.Debug) {
            System.out.println(String.format("createBinarylNode(%s, %s, %s) = %s", operator.toString(), left.toString(), right.toString(), node.toString()));
        }
        return node;
    }

    private AbstractNode createLogicalNode(Token operator, AbstractNode left, AbstractNode right) {
        LogicalNode node = new LogicalNode(operator, left, right);
        if (this.Debug) {
            System.out.println(String.format("createLogicalNode(%s, %s, %s) = %s", operator.toString(), left.toString(), right.toString(), node.toString()));
        }
        return node;
    }

    private AbstractNode createUnaryNode(AbstractNode left) {
        UnaryNode node = new UnaryNode(new Token(45, "0", 0, 0), left);
        if (this.Debug) {
            System.out.println("createUnaryNode(" + left + ") = " + node);
        }
        return node;
    }

    private AbstractNode createValueNode(Number value) {
        ValueNode node = new ValueNode(value);
        if (this.Debug) {
            System.out.println("createValueNode(" + value + ") = " + node);
        }
        return node;
    }

    public Object execute(Scope scope) {
        return this._root.execute(scope);
    }
}

