/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.other;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import java.io.IOException;
import java.util.Json;

public class ExecuteScriptMethod
extends Action {
    private final ExpressionEngine _expressionEngine = new ExpressionEngine();
    private final String _script = this._paramsJson.getString("Script");

    public ExecuteScriptMethod(Task parentTask, Json json) {
        super(parentTask, json);
        System.out.println("\r\nscript:\r\n" + this._script);
        try {
            long startParse = System.currentTimeMillis();
            this._expressionEngine.parse(this._script);
            long elapsedParse = System.currentTimeMillis() - startParse;
            System.out.println(String.format("  elapsed parse %lld", elapsedParse));
        }
        catch (Exception ex) {
            AppLog.error("error parsing script block", ex);
        }
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            long startExecute = System.currentTimeMillis();
            this._expressionEngine.execute(taskRuntime.Scope);
            long elapsedExecute = System.currentTimeMillis() - startExecute;
            System.out.println(String.format("  elapsed execute %lld", elapsedExecute));
        }
        catch (Throwable ex) {
            AppLog.error(ex);
            ErrorMessage message = new ErrorMessage(ex);
            MessagePumpEngine.postMessage(message.build());
            throw new IOException("Error executing script: " + this._script).initCause(ex);
        }
    }
}

