/* global bootbox, Tasker */

TaskerApp.controller('TriggerController',
    function ($scope, $compile, TaskService, TriggerService, DevicesService, SignalService) {
        var _this = this;



        _this.getDevicesInfo = function () {
            return DevicesService.DevicesInfo;
        };



        _this.getDeviceInfoByType = function (type) {
            return DevicesService.getDeviceInfoByType(type);
        };



        _this.getTasks = function () {
            return TaskService.TaskList;
        };



        _this.getSignals = function () {
            return SignalService.SignalsList;
        };



        _this.areTriggersLoaded = function () {
            return TriggerService.TriggersLoaded;
        };



        _this.getTriggers = function () {
            return TriggerService.TriggersList;
        };



        _this.addTriggerProfile = function () {
            bootbox.prompt({
                className: 'bb-success',
                title: "What is the name of the new Trigger?",
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Add',
                        className: 'btn-success'
                    }
                },
                callback: function (result) {
                    if (result) {
                        if (undefined == TriggerService.TriggersList) TriggerService.TriggersList = [];

                        // make sure there isnt already one with the same name
                        if (TriggerService.TriggersList) {
                            for (var i = 0; i < TriggerService.TriggersList.length; i++) {
                                if (TriggerService.TriggersList[i].Name === result) {
                                    bootbox.alert({
                                        className: 'bb-danger',
                                        title: "Duplicate Trigger Name",
                                        message: "Trigger already exists with the name: <b>" + result + '</b>'
                                    });
                                    return false;
                                }
                            }
                        }

                        TriggerService.TriggersList.push({ Name: result, Params: { Enabled: true }, GUID: guid() });
                        $scope.$apply();
                    }
                }
            }).init(function () {
                // $(".bootbox-input").keyup(function (e) {
                //     this.value = this.value.replace(/ /g, '_');
                //     this.value = this.value.replace(/^[0-9]+|[^a-zA-Z0-9_]/g, '');

                //     if (e.which == 13) {
                //         e.preventDefault();
                //         $(".bootbox .btn-submit").click();
                //     }
                // });    

                $(".bootbox-input").keypress(function (evt) {
                    var char = String.fromCharCode(evt.which);
                    var newChar = char.replace(/ /g, '_');
                    newChar = newChar.replace(/^[0-9]+|[^a-zA-Z0-9_]/g, '');
                    if ('' == newChar) return false;
                    if (newChar != char) {
                        this.setRangeText(newChar, this.selectionStart, this.selectionEnd, "end");
                        return false;
                    }
                });
            });

        };



        _this.editTriggerName = function (trigger) {
            bootbox.prompt({
                title: "Edit the name of the Trigger?",
                // message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
                //     ' Trigger can have negative consequences if it it referenced elsewhere in Tasker. ' +
                //     ' Please make sure to change the name used in the references.</p>',
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Update',
                        className: 'btn-success'
                    }
                },
                value: trigger.Name,
                callback: function (result) {
                    if (result) {
                        trigger.Name = result;
                        $scope.$apply();
                    }
                }
            }).init(function () {
                $(".bootbox-input").keyup(function (e) {
                    this.value = this.value.replace(/ /g, '_');
                    this.value = this.value.replace(/^[0-9]+|[^a-zA-Z0-9_]/g, '');

                    if (e.which == 13) {
                        e.preventDefault();
                        $(".bootbox .btn-submit").click();
                    }
                });
            });
        };



        _this.removeTriggerProfile = function (triggerProfile) {
            _this.SaveDialog = bootbox.confirm({
                className: 'bb-warning',
                title: "Are you sure you want to remove the " + triggerProfile.Name + " trigger profile?",
                message: "Are you sure you want to remove the <b>" + triggerProfile.Name + "</b> trigger profile?",
                buttons: {
                    cancel: {
                        label: 'Cancel',
                        className: 'btn-default'
                    },
                    confirm: {
                        label: 'Remove',
                        className: 'btn-warning'
                    }
                },
                callback: function (result) {
                    if (result) {
                        for (var i = TriggerService.TriggersList.length - 1; i >= 0; i--) {
                            if (TriggerService.TriggersList[i] === triggerProfile) {
                                TriggerService.TriggersList.splice(i, 1);
                                $scope.$apply();
                                return;
                            }
                        }
                    }
                }
            });
            _this.SaveDialog.init(function () {
                $("#bootbox-confirm-btn").prop('disabled', false);
                $("#bootbox-cancel-btn").prop('disabled', false);
            });
        };

    });



/*
   SERVICE
*/
TaskerApp.service('TriggerService', function ($rootScope) {
    var _this = this;
    _this.TriggersList = [];
    _this.SelectedTrigger = null;
    _this.TriggersLoaded = false;



    _this.load = function (triggerListJson) {
        if (undefined == triggerListJson) triggerListJson = [];

        try {
            // parseTriggerFile(json);

            _this.TriggersList = triggerListJson;
        } catch (err) {
            console.error(err);
        }

        _this.SelectedTrigger = null;
        _this.TriggersLoaded = true;

        return _this.TriggersList;
    };



    _this.validate = function () {
        var form = $("#triggers-form");
        form.validate({ errorPlacement: function (error, element) { } });
        return form.valid();
    };
});