/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http;

import com.integpg.janoslib.http.HttpResponse;
import com.integpg.janoslib.http.HttpURL;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.SystemOutLog;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.util.Enumeration;
import java.util.Hashtable;

public class HttpRequest {
    private static final Hashtable<String, String> _cachedHosts = new Hashtable();
    private Logger _requestLog = SystemOutLog.getLogger();
    private final HttpURL _url;
    private Socket _socket;
    private String _type = "GET";
    private byte[] _data;
    private final Hashtable<String, String> _userHeaders = new Hashtable();
    private int _length = 0;

    public HttpRequest(HttpURL url) {
        this._url = url;
    }

    public void setLog(Logger log) {
        this._requestLog = log;
    }

    public Logger getLogger() {
        return this._requestLog;
    }

    public String getRequestMethod() {
        return this._type;
    }

    public void setRequestMethod(String type) {
        this._type = type;
    }

    public void addHeader(String name, String value) {
        this._userHeaders.put(name, value);
    }

    public void setData(byte[] data) {
        this._data = data;
    }

    public HttpResponse sendRequest() throws IOException {
        this._requestLog.info(this._type + " /" + this._url.toString());
        String address = "0.0.0.0";
        try {
            InetAddress resolvedAddress = InetAddress.getByName(this._url.getHost());
            address = resolvedAddress.getHostAddress();
            _cachedHosts.put(this._url.getHost(), address);
        }
        catch (Exception ex) {
            if (_cachedHosts.containsKey(this._url.getHost())) {
                address = _cachedHosts.get(this._url.getHost());
                this._requestLog.warn("resolution failed, use cached address: " + address);
            }
            this._requestLog.warn("resolution failed!  No cached address to use");
        }
        this._socket = new Socket(address, this._url.getPort());
        this._socket.setSoTimeout(15000);
        if (-1 != this._url.toString().toLowerCase().indexOf("https")) {
            System.out.println("set secure");
            this._socket.setSecure(true);
        }
        this.sendHeaders();
        if (null != this._data) {
            this.sendData();
        }
        return new HttpResponse(this);
    }

    private void sendHeaders() throws IOException {
        OutputStream out = this.getOutputStream();
        String headers = this._type + " /" + this._url.getFile() + this._url.getQuery() + " HTTP/1.1\r\n" + "Host: " + this._url.getHost() + "\r\n" + "Connection: close\r\n" + "Pragma: no-cache\r\n" + "Cache-Control: no-cache\r\n";
        headers = null != this._data ? headers + "Content-Length: " + this._data.length + "\r\n" : headers + "Content-Length: 0\r\n";
        if (0 < this._userHeaders.size()) {
            Enumeration<String> headerEnumeration = this._userHeaders.keys();
            while (headerEnumeration.hasMoreElements()) {
                String name = headerEnumeration.nextElement();
                String value = this._userHeaders.get(name);
                headers = headers + name + ": " + value + "\r\n";
            }
        }
        headers = headers + "\r\n";
        out.write(headers.getBytes());
        out.flush();
        this._length += headers.length();
    }

    private void sendData() throws IOException {
        if (null != this._data) {
            OutputStream out = this.getOutputStream();
            out.write(this._data);
            out.flush();
            this._length += this._data.length;
        }
    }

    public OutputStream getOutputStream() throws SocketException, IOException {
        if (this._socket == null) {
            throw new SocketException("Socket not yet connected");
        }
        return this._socket.getOutputStream();
    }

    public InputStream getInputStream() throws SocketException, IOException {
        if (this._socket == null) {
            throw new SocketException("Socket not yet connected");
        }
        return this._socket.getInputStream();
    }

    public int getRequestLength() {
        return this._length;
    }

    public void close() throws IOException {
        if (null != this._socket) {
            System.out.println("close HTTPRequest");
            if (null != this.getInputStream()) {
                this.getInputStream().close();
            }
            if (null != this.getOutputStream()) {
                this.getOutputStream().close();
            }
            this._socket.close();
        }
    }
}

