/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.devices.Device;
import com.integ.tasker.tasks.Scope;
import com.integ.tasker.webhandlers.ErrorMessage;
import com.integpg.janoslib.utils.HexUtils;
import java.io.DataInputStream;
import java.net.Socket;
import java.util.Json;

public class EthernetDevice
extends Device {
    private String _ipAddress;
    private int _port;
    private Socket _socket = null;

    public EthernetDevice(Json json) {
        super(json);
        try {
            Json paramsJson = (Json)json.get("Params");
            this._ipAddress = paramsJson.getString("IpAddress");
            this._port = paramsJson.getInt("Port");
            LOG.info(String.format("ipAddress: %s, port: %d", this._ipAddress, this._port));
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    public String getIpAddress() {
        return this._ipAddress;
    }

    public int getPort() {
        return this._port;
    }

    public void send(byte[] bytes) throws Exception {
        String host = this.getIpAddress();
        int port = this.getPort();
        boolean retry = true;
        if (retry) {
            try {
                if (null == this._socket) {
                    LOG.info(String.format("connecting to %s", this.Name));
                    this._socket = new Socket(host, port);
                }
                if (null != this._socket) {
                    this._socket.getOutputStream().write(bytes);
                }
            }
            catch (Exception ex) {
                this.close();
                retry = false;
                throw ex;
            }
        }
    }

    public void receive(Scope scope) throws Exception {
        try {
            if (null != this._socket) {
                DataInputStream dis = new DataInputStream(this._socket.getInputStream());
                byte[] newArray = new byte[dis.available()];
                int bytesRead = dis.read(newArray);
                scope.setVariable(String.format("%s_buffer", this.Name), newArray);
                Device.LOG.info(String.format("%s read %d bytes: %s", this.Name, bytesRead, HexUtils.bytesToHex(newArray)));
            }
        }
        catch (Exception ex) {
            this.close();
            throw ex;
        }
    }

    public void close() throws Exception {
        try {
            if (null != this._socket) {
                LOG.info(String.format("closing %s", this.Name));
                this._socket.close();
                this._socket = null;
            }
        }
        catch (Exception ex) {
            this._socket = null;
            throw ex;
        }
    }
}

