/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker.ast;

import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;
import com.integpg.tasker.ast.ASTBinaryNode;
import com.integpg.tasker.ast.ASTBooleanNode;
import com.integpg.tasker.ast.ASTLogicalNode;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTUnaryNode;
import com.integpg.tasker.ast.ASTValueNode;
import com.integpg.tasker.ast.ASTVariableNode;
import java.util.Hashtable;
import java.util.Stack;

public class ASTParser {
    private static final Hashtable<Integer, Integer> OPERATOR_PRECEDENCE = new Hashtable();
    private static boolean DEBUG;
    private final String _expressionString;
    private final Scope _scope;

    public ASTParser(String expressionString, Scope scope) throws Exception {
        this._expressionString = expressionString;
        this._scope = scope;
    }

    public String getExpressionString() {
        return this._expressionString;
    }

    public static void setDebug(boolean debug) {
        DEBUG = debug;
    }

    public static boolean isDebug() {
        return DEBUG;
    }

    public ASTNode parse() {
        ASTNode node = null;
        try {
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, this._expressionString);
            TokenStream tokens = new TokenStream(tokenQueue);
            Stack<ASTNode> outputStack = new Stack<ASTNode>();
            Stack<Token> operatorStack = new Stack<Token>();
            while (!tokens.isEmpty()) {
                Token operatorStackToken;
                boolean isOperator;
                Token token = tokens.nextToken();
                if (DEBUG) {
                    System.out.println("token: " + token);
                }
                if (token.checkType(3)) {
                    double value = Double.valueOf(token.content);
                    outputStack.addElement(new ASTValueNode(value));
                    ASTParser.printStack(outputStack, "output");
                }
                if (token.checkType(0)) {
                    if (token.checkContent("true") || token.checkContent("false")) {
                        boolean b = Boolean.valueOf(token.content);
                        outputStack.addElement(new ASTBooleanNode(b));
                    } else {
                        StringBuilder sb = new StringBuilder(token.content);
                        if (!tokens.isEmpty() && tokens.peekToken().checkType(91)) {
                            token = tokens.nextToken();
                            sb.append(token.content);
                            token = tokens.nextToken();
                            if (!token.checkType(3)) {
                                // empty if block
                            }
                            sb.append(token.content);
                            token = tokens.nextToken();
                            if (!token.checkType(93)) {
                                // empty if block
                            }
                            sb.append(token.content);
                        }
                        if (!tokens.isEmpty() && tokens.peekToken().checkType(46)) {
                            token = tokens.nextToken();
                            sb.append(token.content);
                            token = tokens.nextToken();
                            sb.append(token.content);
                        }
                        if (!tokens.isEmpty() && tokens.peekToken().checkType(40)) {
                            token = tokens.nextToken();
                            sb.append(token.content);
                            token = tokens.nextToken();
                            while (!token.checkType(41)) {
                                sb.append(token.content);
                                token = tokens.nextToken();
                            }
                            sb.append(token.content);
                        }
                        String identifier = sb.toString();
                        System.out.println("identifier: " + identifier);
                        if (null != this._scope) {
                            System.out.println("scope.contains(" + identifier + "): " + this._scope.contains(identifier));
                            if (this._scope.contains(identifier)) {
                                identifier = String.valueOf(this._scope.getVariable(identifier));
                            }
                            System.out.println("identifier: " + identifier);
                            token.content = identifier;
                        }
                        if (token.checkContent("true") || token.checkContent("false")) {
                            boolean b = Boolean.valueOf(token.content);
                            outputStack.addElement(new ASTBooleanNode(b));
                        } else {
                            token = new Token(0, sb.toString(), 0, 0);
                            outputStack.addElement(new ASTVariableNode(token.content));
                        }
                        ASTParser.printStack(outputStack, "output");
                    }
                }
                if (isOperator = OPERATOR_PRECEDENCE.containsKey(token.type)) {
                    if (0 < operatorStack.size()) {
                        operatorStackToken = (Token)operatorStack.peek();
                        boolean isOperator2 = OPERATOR_PRECEDENCE.containsKey(operatorStackToken.type);
                        if (isOperator2) {
                            int newOperatorPrecedenceValue = OPERATOR_PRECEDENCE.get(token.type);
                            int stackOperatorPrecedenceValue = OPERATOR_PRECEDENCE.get(operatorStackToken.type);
                            if (stackOperatorPrecedenceValue >= newOperatorPrecedenceValue) {
                                ASTNode left;
                                ASTNode right;
                                operatorStackToken = (Token)operatorStack.pop();
                                if (operatorStackToken.checkType(43) || operatorStackToken.checkType(45) || operatorStackToken.checkType(47) || operatorStackToken.checkType(42)) {
                                    right = (ASTNode)outputStack.pop();
                                    left = (ASTNode)outputStack.pop();
                                    outputStack.addElement(new ASTBinaryNode(operatorStackToken, left, right));
                                } else if (operatorStackToken.checkType(33)) {
                                    right = (ASTNode)outputStack.pop();
                                    outputStack.addElement(new ASTUnaryNode(operatorStackToken, right));
                                } else {
                                    right = (ASTNode)outputStack.pop();
                                    left = (ASTNode)outputStack.pop();
                                    outputStack.addElement(new ASTLogicalNode(operatorStackToken, left, right));
                                }
                                ASTParser.printStack(outputStack, "output");
                                ASTParser.printStack(operatorStack, "operators");
                            }
                        }
                    }
                    operatorStack.addElement(token);
                    ASTParser.printStack(operatorStack, "operators");
                }
                if (token.checkType(40)) {
                    operatorStack.addElement(token);
                    ASTParser.printStack(operatorStack, "operators");
                }
                if (!token.checkType(41)) continue;
                while (!(operatorStackToken = (Token)operatorStack.pop()).checkType(40)) {
                    ASTNode right;
                    System.out.println("operatorStackToken: " + operatorStackToken);
                    if (operatorStackToken.checkType(43) || operatorStackToken.checkType(45) || operatorStackToken.checkType(47) || operatorStackToken.checkType(42)) {
                        right = (ASTNode)outputStack.pop();
                        ASTNode left = (ASTNode)outputStack.pop();
                        outputStack.addElement(new ASTBinaryNode(operatorStackToken, left, right));
                    } else if (operatorStackToken.checkType(33)) {
                        right = (ASTNode)outputStack.pop();
                        outputStack.addElement(new ASTUnaryNode(operatorStackToken, right));
                    } else {
                        right = (ASTNode)outputStack.pop();
                        ASTNode left = (ASTNode)outputStack.pop();
                        outputStack.addElement(new ASTLogicalNode(operatorStackToken, left, right));
                    }
                    ASTParser.printStack(outputStack, "output");
                }
            }
            ASTParser.printStack(outputStack, "output");
            ASTParser.printStack(operatorStack, "operators");
            while (0 < operatorStack.size()) {
                ASTNode left;
                ASTNode right;
                Token operatorStackToken = (Token)operatorStack.pop();
                System.out.println("operatorStackToken: " + operatorStackToken);
                if (operatorStackToken.checkType(43) || operatorStackToken.checkType(45) || operatorStackToken.checkType(47) || operatorStackToken.checkType(42)) {
                    right = (ASTNode)outputStack.pop();
                    left = (ASTNode)outputStack.pop();
                    outputStack.addElement(new ASTBinaryNode(operatorStackToken, left, right));
                    continue;
                }
                if (operatorStackToken.checkType(33)) {
                    right = (ASTNode)outputStack.pop();
                    outputStack.addElement(new ASTUnaryNode(operatorStackToken, right));
                    continue;
                }
                right = (ASTNode)outputStack.pop();
                left = (ASTNode)outputStack.pop();
                outputStack.addElement(new ASTLogicalNode(operatorStackToken, left, right));
            }
            ASTParser.printStack(outputStack, "output");
            ASTParser.printStack(operatorStack, "operators");
            node = (ASTNode)outputStack.pop();
        }
        catch (Exception ex) {
            ex.printStackTrace(System.err);
        }
        return node;
    }

    private static void printStack(Stack stack, String title) {
        if (DEBUG) {
            System.out.println(title);
            for (int i = 0; i < stack.size(); ++i) {
                System.out.println("   " + i + ": " + stack.elementAt(i));
            }
        }
    }

    static {
        OPERATOR_PRECEDENCE.put(9, 3);
        OPERATOR_PRECEDENCE.put(10, 4);
        OPERATOR_PRECEDENCE.put(11, 8);
        OPERATOR_PRECEDENCE.put(12, 8);
        OPERATOR_PRECEDENCE.put(60, 9);
        OPERATOR_PRECEDENCE.put(14, 9);
        OPERATOR_PRECEDENCE.put(62, 9);
        OPERATOR_PRECEDENCE.put(13, 9);
        OPERATOR_PRECEDENCE.put(45, 10);
        OPERATOR_PRECEDENCE.put(43, 10);
        OPERATOR_PRECEDENCE.put(47, 11);
        OPERATOR_PRECEDENCE.put(42, 11);
        OPERATOR_PRECEDENCE.put(94, 12);
        OPERATOR_PRECEDENCE.put(33, 12);
    }
}

