/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;

public class IoLogObject
extends AbstractObjectCall {
    private static final Iolog INPUT_IO_LOG = new Iolog();

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            Token nextToken = parser.nextToken();
            if (nextToken.checkType(46)) {
                nextToken = parser.nextToken();
                if (!nextToken.checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                switch (this._fieldOrMethodName = parser.currentToken().content) {
                    case "lasteventtime": {
                        this.parseArguments(parser);
                    }
                }
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process relay output");
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        if ("lasteventtime".equalsIgnoreCase(this._fieldOrMethodName)) {
            INPUT_IO_LOG.refresh();
            IoEvent[] inputEvents = INPUT_IO_LOG.getInputEvents(1);
            IoEvent lastInputEvent = inputEvents[0];
            IoEvent[] outputEvents = INPUT_IO_LOG.getOutputEvents(1);
            IoEvent lastOutputEvent = outputEvents[0];
            return Math.max(lastInputEvent.timestamp, lastOutputEvent.timestamp);
        }
        return null;
    }

    public static Object read(int channel, String fieldOrMethodName) {
        if ("state".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getOutputStates() >> channel - 1 & 1;
        }
        if ("usagemeter".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getUsageMeter((int)(UnitConfig.getInputCount() + channel - 1));
        }
        throw new RuntimeException(String.format("unknown field or method: %s", fieldOrMethodName));
    }
}

