/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.lexer.Token;
import com.integ.tasker.tasks.Scope;
import com.integpg.system.IoEvent;
import com.integpg.system.Iolog;
import com.integpg.system.JANOS;

public class DigitalInputObject
extends AbstractObjectCall {
    private static final Iolog INPUT_IO_LOG = new Iolog();
    private int _channel = -1;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            Token nextToken = parser.nextToken();
            if (nextToken.checkType(46)) {
                nextToken = parser.nextToken();
                if (!nextToken.checkType(0)) {
                    throw new UnexpectedTokenException("FIELD OR METHOD NAME", parser.currentToken());
                }
                switch (this._fieldOrMethodName = parser.currentToken().content) {
                    case "lasteventtime": 
                    case "lasteventchannelmask": 
                    case "lasteventchannelstates": {
                        this.parseArguments(parser);
                    }
                }
            } else {
                if (!nextToken.checkType(91)) {
                    throw new UnexpectedTokenException("[", parser.currentToken());
                }
                if (!parser.nextToken().checkType(3)) {
                    throw new UnexpectedTokenException("NUMBER", parser.currentToken());
                }
                ValueNode valueNode = (ValueNode)parser.getObject();
                this._channel = (Integer)valueNode.Value;
                if (!parser.nextToken().checkType(93)) {
                    throw new UnexpectedTokenException("]", parser.currentToken());
                }
                if (!parser.nextToken().checkType(46)) {
                    throw new UnexpectedTokenException(".", parser.currentToken());
                }
                if (!parser.nextToken().checkType(0)) {
                    throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
                }
                this._fieldOrMethodName = parser.currentToken().content;
                if (parser.peekToken().checkType(40)) {
                    this.parseArguments(parser);
                }
            }
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process digital input");
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        if (-1 == this._channel) {
            if ("lasteventtime".equalsIgnoreCase(this._fieldOrMethodName)) {
                IoEvent lastEvent = this.getLastEvent();
                return null != lastEvent ? lastEvent.timestamp : -1L;
            }
            if ("lasteventchannelmask".equalsIgnoreCase(this._fieldOrMethodName)) {
                IoEvent lastEvent = this.getLastEvent();
                return null != lastEvent ? lastEvent.mask : -1;
            }
            if ("lasteventchannelstates".equalsIgnoreCase(this._fieldOrMethodName)) {
                IoEvent lastEvent = this.getLastEvent();
                return null != lastEvent ? lastEvent.states : -1;
            }
        } else if (this._isMethod) {
            if ("lasteventhightime".equalsIgnoreCase(this._fieldOrMethodName) || "lastrisingtime".equalsIgnoreCase(this._fieldOrMethodName)) {
                return this.getLastEventTime(1);
            }
            if ("lasteventlowtime".equalsIgnoreCase(this._fieldOrMethodName) || "lastfallingtime".equalsIgnoreCase(this._fieldOrMethodName)) {
                return this.getLastEventTime(0);
            }
            if ("lasteventtime".equalsIgnoreCase(this._fieldOrMethodName)) {
                return this.getLastEventTime(2);
            }
        } else {
            return DigitalInputObject.read(this._channel, this._fieldOrMethodName);
        }
        return null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IoEvent getLastEvent() {
        Iolog iolog = INPUT_IO_LOG;
        synchronized (iolog) {
            INPUT_IO_LOG.refresh();
            IoEvent[] events = INPUT_IO_LOG.getInputEvents(1);
            System.out.println(String.format("%d events for", events.length));
            return 0 < events.length ? events[0] : null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private long getLastEventTime(int edge) {
        Iolog iolog = INPUT_IO_LOG;
        synchronized (iolog) {
            INPUT_IO_LOG.refresh();
            long[] eventTimes = INPUT_IO_LOG.getInputTransitions(this._channel - 1, edge, 1);
            System.out.println(String.format("%d %d edge events for channel %d", eventTimes.length, edge, this._channel));
            return 0 < eventTimes.length ? eventTimes[0] : -1L;
        }
    }

    public static Object read(int channel, String fieldOrMethodName) {
        if ("state".equalsIgnoreCase(fieldOrMethodName)) {
            return 0 != (JANOS.getInputStates() >> channel - 1 & 1);
        }
        if ("counter".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getInputCounter((int)(channel - 1));
        }
        if ("usagemeter".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getUsageMeter((int)(channel - 1));
        }
        throw new RuntimeException(String.format("unknown field or method: %s", fieldOrMethodName));
    }
}

