/*
 * Decompiled with CFR 0.152.
 */
package com.integ.janoslib.messagepump;

import com.integ.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.janoslib.messagepump.MessagePumpListener;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.logger.SystemOutLog;
import com.integpg.system.SystemMsg;
import java.util.Hashtable;
import java.util.Json;

public class MessagePumpAppHandler
implements MessagePumpListener {
    private static final Logger LOG = SystemOutLog.getLogger();
    private final Hashtable<String, MessagePumpAppMessageListener> _appMessageListeners = new Hashtable();
    private final int _type;
    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;

    public MessagePumpAppHandler(int type) {
        this._type = type;
    }

    public MessagePumpAppHandler addCommandListener(String command, MessagePumpAppMessageListener listener) {
        this._appMessageListeners.put(command, listener);
        LOG.info(String.format("   added handler for %s:%d = %s", command, this._type, listener.getClass().getName()));
        return this;
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (this._type == systemMsg.type) {
            this._systemMsg = systemMsg;
            long start = System.currentTimeMillis();
            this.processMessage();
            long l = System.currentTimeMillis() - start;
        }
    }

    private void processMessage() {
        MessagePumpAppMessageListener listener;
        String contentJsonString = new String(this._systemMsg.msg);
        this._receivedJson = new Json(contentJsonString);
        this._messageString = this._receivedJson.getString("Message");
        if (this._appMessageListeners.containsKey(this._messageString) && null != (listener = this._appMessageListeners.get(this._messageString))) {
            listener.applicationMessageReceived(this._receivedJson);
        }
    }

    private void sendReponse(Json json) {
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = this._systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }
}

