/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting;

import com.integ.scripting.ExpressionEngine;
import com.integ.tasker.tasks.Scope;
import com.integpg.system.JANOS;
import java.io.IOException;

public class ScriptTest {
    private static final ExpressionEngine EXPRESSION_Engine = new ExpressionEngine();
    private static final Scope SCOPE = new Scope();

    private static void setDebug(boolean debug) {
        EXPRESSION_Engine.setDebug(debug);
        SCOPE.setDebug(debug);
    }

    public static void main(String[] args) throws Exception {
        ScriptTest.assertEquals("6 + 4 - 4 * 2", 2);
        ScriptTest.assertEquals("6 * 4 - 4 * 2", 16);
        ScriptTest.assertEquals("6 * (6 - 4) * 2", 24);
        ScriptTest.assertEquals("temp[1].f > 60", true);
        ScriptTest.setOutputs(0, 15);
        ScriptTest.setOutputs(1, 1);
        ScriptTest.assertEquals("rout[1].state == 1", true);
        ScriptTest.assertEquals("rout[1].state != 0", true);
        ScriptTest.assertEquals("rout[1].state == 1 && true", true);
        ScriptTest.setOutputs(2, 2);
        ScriptTest.assertEquals("rout[1].state == 1 && rout[2].state == 1", true);
        ScriptTest.assertEquals("(rout[1].state == 1 || rout[2].state == 1) == true", true);
        ScriptTest.setDebug(false);
        ScriptTest.setOutputs(0, 15);
        ScriptTest.assertEquals("rout[1].state != 1 && rout[2].state == 0", true);
        ScriptTest.setOutputs(2, 2);
        ScriptTest.assertEquals("rout[1].state != 0 || rout[2].state != 0", true);
        ScriptTest.assertEquals("(rout[1].state == 1 && rout[2].state == 1) || true", true);
        ScriptTest.setDebug(false);
        ScriptTest.setOutputs(1, 1);
        ScriptTest.assertEquals("(rout[1].state == 1 && rout[2].state == 1) || (rout[3].state == 1 && rout[4].state == 1)", true);
        ScriptTest.setOutputs(12, 15);
        ScriptTest.assertEquals("(rout[1].state == 1 && rout[2].state == 1) || (rout[3].state == 1 && rout[4].state == 1)", true);
        ScriptTest.setOutputs(10, 15);
        ScriptTest.assertEquals("(rout[1].state == 1 || rout[2].state == 1) && (rout[3].state == 1 || rout[4].state == 1)", true);
        ScriptTest.setOutputs(0, 15);
    }

    private static void setOutputs(int statesMask, int bitsMask) throws IOException {
        for (int i = 0; i < 16 && 0 != bitsMask; bitsMask >>= 1, ++i) {
            if (1 == (bitsMask & 1)) {
                boolean channelState = 1 == (statesMask & 1);
                System.out.println(String.format("set output %d %s", i + 1, channelState ? "ON" : "OFF"));
                JANOS.setOutputRelay((int)i, (boolean)channelState);
            }
            statesMask >>= 1;
        }
    }

    private static void assertEquals(String script, Object expectedResult) {
        try {
            System.out.println("\r\n\r\nscript:\r\n" + script);
            long startParse = System.currentTimeMillis();
            EXPRESSION_Engine.parse(script);
            long elapsedParse = System.currentTimeMillis() - startParse;
            System.out.println(String.format("  elapsed parse %lld", elapsedParse));
            long startExecute = System.currentTimeMillis();
            Object result = EXPRESSION_Engine.execute(SCOPE);
            long elapsedExecute = System.currentTimeMillis() - startExecute;
            System.out.println("result = " + result);
            System.out.println(String.format("  elapsed execute %lld", elapsedExecute));
            long elapsedTotal = elapsedParse + elapsedExecute;
            System.out.println(String.format("  total elapsed %lld", elapsedTotal));
            System.out.println("result = " + result.getClass());
            System.out.println("expectedResult = " + expectedResult.getClass());
            if (!expectedResult.equals(result)) {
                throw new RuntimeException(String.format("The script %s does not result to %s", script, String.valueOf(expectedResult)));
            }
            System.out.println("");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

