function parseControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'Function':
            return new ControlFunction();

        case 'WhileLoop':
            return new WhileLoop();

        case 'ForLoop':
            return new ForLoop();

        case 'IfBlock':
            return new IfBlock();

        case 'IfElseBlock':
            return new IfElseBlock();

        case 'SetVariable':
            return new SetVariable();

        default:
            throw new Error('Unknown Action Method: ' + JSON.stringify(json, null, 2));
    }
}



///////////////////////////////////////////////////////////////////////////////////////////////////
//
//                                         Control Actions
//
///////////////////////////////////////////////////////////////////////////////////////////////////

class IfBlock extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'IfBlock';
        this.Params.Conditional = conditional;
    }

    editTemplate() {
        return 'If <input class="form-control" ng-model="action.Params.Conditional" style="width:600px" data-toggle="tooltip" title="A conditional expresssion that evaluates to true or false"/>' +
            ' <a href="help/#?blockId=controlstructures-ifblock" target="blank" style="font-size:16px;">' +
            ' <i class="fa fa-question-circle text-primary"></i></a> then';
    }
}



class IfElseBlock extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'IfElseBlock';
        this.Params.Conditional = conditional;
        this.Params.ElseActions = [];
    }


    parse(json) {
        super.parse(json);

        for (var i = 0; i < this.Params.ElseActions.length; i++) {
            var actionJson = this.Params.ElseActions[i];
            this.Params.ElseActions[i] = parseAction(actionJson, this);
        }
    }


    editTemplate() {
        return 'If <input class="form-control" ng-model="action.Params.Conditional" style="width:600px"/> then';
    }


    getAdditionalHtml() {
        return Actions.prototype.getAdditionalHtml() +
            '\r\n<div style="margin: 4px 12px;">\r\n' +
            '  Else\r\n' +
            '</div>\r\n' +
            '\r\n<div style="margin: 4px 24px; border-left: 1px solid #333; padding-left: 8px;">\r\n' +
            '  <action-block action="action" actions="action.Params.ElseActions" edit="edit" parent="parent" controller="controller"></action-block>\r\n' +
            '</div>\r\n';
    }
}



class ForLoop extends Actions {
    constructor(variable, from, to) {
        super();
        this.Type = 'Control';
        this.Method = 'ForLoop';
        this.Params.Variable = variable;
        this.Params.From = from;
        this.Params.To = to;
    }

    editTemplate() {
        return 'Loop <input class="form-control" ng-model="action.Params.Variable" data-toggle="tooltip" title="Variable Name"' +
            '   name="loop-variable-' + guid() + '" required />' +
            ' from <input class="form-control" ng-model="action.Params.From" data-toggle="tooltip" title="Starting Variable (Inclusive)"' +
            '   name="loop-from-' + guid() + '" required />' +
            ' to <input class="form-control" ng-model="action.Params.To" data-toggle="tooltip" title="Ending Variable (Inclusive)"' +
            '   name="loop-to-' + guid() + '" required /> ';
    }
}



class WhileLoop extends Actions {
    constructor(conditional) {
        super();
        this.Type = 'Control';
        this.Method = 'WhileLoop';
        this.Params.Conditional = conditional;
    }

    editTemplate() {
        return 'While <input class="form-control" ng-model="action.Params.Conditional" style="width:600px" data-toggle="tooltip" title="A conditional expresssion that evaluates to true or false"/>';
    }
}



class SetVariable extends Action {
    constructor() {
        super();
        this.Type = 'Control';
        this.Method = 'SetVariable';
        this.Params = {};
    }

    editTemplate() {
        return 'Set <input class="form-control prevent-spaces" ng-model="action.Params.Variable" style="width:150px" data-toggle="tooltip" title="A variable name.  Prefixing \'$$\' makes the variable Global and can be referenced by other Tasks"/>' +
            ' = <input class="form-control" ng-model="action.Params.Conditional" style="width:450px" data-toggle="tooltip" title="The value to assign to the variable"/>';
    }
}