/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices.osc;

import com.integ.tasker.devices.osc.OSCFloat;
import com.integ.tasker.devices.osc.OSCInteger;
import com.integ.tasker.devices.osc.OSCObject;
import com.integ.tasker.devices.osc.OSCString;
import com.integpg.system.ArrayUtils;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.util.ArrayList;

public class OSCMessage
extends OSCObject {
    private final String _address;
    private final StringBuilder _typeString = new StringBuilder(",");
    private final ArrayList<OSCObject> _arguments = new ArrayList();
    private final ArrayList<Object> _values = new ArrayList();

    public OSCMessage(String address) {
        this._address = address;
    }

    public OSCMessage(byte[] bytes) {
        ByteArrayInputStream byteArrayInputStream = new ByteArrayInputStream(bytes);
        OSCString addressString = new OSCString(byteArrayInputStream);
        System.out.println("addressString = " + addressString.getValue());
        OSCString typeString = new OSCString(byteArrayInputStream);
        System.out.println("typeString = " + typeString.getValue());
        int pos = 0;
        while (0 != bytes[pos]) {
            ++pos;
        }
        this._address = new String(bytes, 0, pos);
        System.out.println("_address = " + this._address);
        pos = (pos / 4 + 1) * 4;
        this._typeString.setLength(0);
        while (0 != bytes[pos]) {
            this._typeString.append((char)bytes[pos]);
            ++pos;
        }
        System.out.println("_typeString = " + this._typeString);
        pos = (pos / 4 + 1) * 4;
        block7: for (int i = 1; i < this._typeString.length(); ++i) {
            char chr = this._typeString.charAt(i);
            switch (chr) {
                case 'i': {
                    int intValue = ArrayUtils.getInt((byte[])bytes, (int)pos);
                    this._values.add(intValue);
                    System.out.println("intValue = " + intValue);
                    pos += 4;
                    continue block7;
                }
                case 'f': {
                    int intBits = ArrayUtils.getInt((byte[])bytes, (int)pos);
                    float floatValue = Float.intBitsToFloat(intBits);
                    this._values.add(Float.valueOf(floatValue));
                    System.out.println("floatValue = " + floatValue);
                    pos += 4;
                    continue block7;
                }
                case 's': {
                    int start = pos;
                    while (0 != bytes[pos]) {
                        ++pos;
                    }
                    String s = new String(bytes, start, pos - start);
                    this._values.add(s);
                    System.out.println("s = " + s);
                    pos = (pos / 4 + 1) * 4;
                }
            }
        }
    }

    public String getAddress() {
        return this._address;
    }

    public void addInteger(int value) {
        this._typeString.append("i");
        this._arguments.add(new OSCInteger(value));
    }

    public void addFloat(float value) {
        this._typeString.append("f");
        this._arguments.add(new OSCFloat(value));
    }

    public void addString(String value) {
        this._typeString.append("s");
        this._arguments.add(new OSCString(value));
    }

    public Object getValueAt(int i) {
        return this._values.get(i);
    }

    @Override
    public byte[] getBytes() {
        try {
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            byteArrayOutputStream.write(new OSCString(this._address).getBytes());
            byteArrayOutputStream.write(new OSCString(this._typeString.toString()).getBytes());
            for (OSCObject argument : this._arguments) {
                byteArrayOutputStream.write(argument.getBytes());
            }
            return byteArrayOutputStream.toByteArray();
        }
        catch (IOException ex) {
            ex.printStackTrace();
            return new byte[0];
        }
    }
}

