/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.debug.ThreadElapsed;
import com.integpg.janoslib.externalio.ExternalDeviceFactory;
import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.Type28;
import com.integpg.janoslib.externalio.Type7E;
import com.integpg.janoslib.externalio.TypeF9;
import com.integpg.janoslib.externalio.TypeFA;
import com.integpg.janoslib.externalio.TypeFB;
import com.integpg.janoslib.externalio.TypeFD;
import com.integpg.janoslib.externalio.TypeFE;
import com.integpg.janoslib.messagepump.RegistryModifiedHandler;
import com.integpg.janoslib.messagepump.RegistryModifiedListener;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.system.JANOS;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExternalDeviceOrder
implements RegistryModifiedListener {
    private static final ExternalDeviceOrder INSTANCE = new ExternalDeviceOrder();
    private static final String PRESENT_DEVICES_REGISTRY_STRING = "externals/$present";
    private static final String DEVICE_ORDER_REGISTRY_STRING = "Externals/DeviceOrder";
    private static final Pattern DEVICE_ORDER_PATTERN = Pattern.compile("type(\\w+)_(\\d)", 1);
    private static final ArrayList<ExternalModule> Type28List = new ArrayList(2);
    private static final ArrayList<ExternalModule> Type7EList = new ArrayList(2);
    private static final ArrayList<ExternalModule> TypeF9List = new ArrayList(2);
    private static final ArrayList<ExternalModule> TypeFAList = new ArrayList(2);
    private static final ArrayList<ExternalModule> TypeFBList = new ArrayList(2);
    private static final ArrayList<ExternalModule> TypeFDList = new ArrayList(2);
    private static final ArrayList<ExternalModule> TypeFEList = new ArrayList(2);
    private static final ArrayList<ExternalModule> AllModules = new ArrayList(2);
    private static final Hashtable<String, ExternalModule> All_Modules_By_Address = new Hashtable();
    private static long Last_Enumeration_time = 0L;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type28[] getType28Array() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (Type28[])Type28List.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Type7E[] getType7EArray() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (Type7E[])Type7EList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeF9[] getTypeF9Array() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (TypeF9[])TypeF9List.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeFA[] getTypeFAArray() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (TypeFA[])TypeFAList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeFB[] getTypeFBArray() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (TypeFB[])TypeFBList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeFD[] getTypeFDArray() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (TypeFD[])TypeFDList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static TypeFE[] getTypeFEArray() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (TypeFE[])TypeFEList.toArray();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ExternalModule[] getAllDevices() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            return (ExternalModule[])AllModules.toArray();
        }
    }

    private static void enumerateDevices() {
        long now = System.currentTimeMillis();
        long timeSinceLastEnumeration = now - Last_Enumeration_time;
        if (1000L < timeSinceLastEnumeration) {
            System.out.println(ThreadElapsed.getElapsed() + "RegistryDeviceOrder.enumerateDevices(), timeSinceLastEnumeration = " + timeSinceLastEnumeration);
            ExternalDeviceOrder.doRegistryDeviceEnumeration();
            System.out.println(ThreadElapsed.getElapsed() + "RegistryDeviceOrder.enumerateDevices() complete");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static void doRegistryDeviceEnumeration() {
        ExternalDeviceOrder externalDeviceOrder = INSTANCE;
        synchronized (externalDeviceOrder) {
            String[] deviceOrderRegistryStrings;
            Last_Enumeration_time = System.currentTimeMillis();
            AllModules.clear();
            String presentDevices = ExternalDeviceOrder.getPresentDevices();
            for (String deviceOrderRegistryString : deviceOrderRegistryStrings = JANOS.getRegistryList((String)DEVICE_ORDER_REGISTRY_STRING)) {
                long address;
                ExternalModule externalModule;
                Matcher match = DEVICE_ORDER_PATTERN.matcher(deviceOrderRegistryString);
                boolean found = match.find();
                if (!found) continue;
                String type = match.group(1);
                int index = Integer.valueOf(match.group(2));
                String deviceRegistryString = String.format("%s/%s", DEVICE_ORDER_REGISTRY_STRING, deviceOrderRegistryString);
                String addressString = JANOS.getRegistryString((String)deviceRegistryString, null);
                if (null == addressString || null == (externalModule = ExternalDeviceFactory.createFromAddress(address = HexUtils.parseHexAsLong(addressString)))) continue;
                All_Modules_By_Address.put(externalModule.AddressString, externalModule);
                ArrayList<ExternalModule> deviceList = null;
                if ("10".equalsIgnoreCase(type) || "28".equalsIgnoreCase(type)) {
                    deviceList = Type28List;
                } else if ("7e".equalsIgnoreCase(type)) {
                    deviceList = Type7EList;
                } else if ("f9".equalsIgnoreCase(type)) {
                    deviceList = TypeF9List;
                } else if ("fa".equalsIgnoreCase(type)) {
                    deviceList = TypeFAList;
                } else if ("fb".equalsIgnoreCase(type)) {
                    deviceList = TypeFBList;
                } else if ("fd".equalsIgnoreCase(type)) {
                    deviceList = TypeFDList;
                } else if ("fe".equalsIgnoreCase(type)) {
                    deviceList = TypeFEList;
                }
                if (null == deviceList) continue;
                deviceList.ensureCapacity(index);
                deviceList.set(index - 1, externalModule);
            }
        }
    }

    public static String getPresentDevices() {
        return JANOS.getRegistryString((String)PRESENT_DEVICES_REGISTRY_STRING, (String)"");
    }

    public static long getDeviceAddressForDeviceString(String deviceTypeIndex) {
        String addressString = JANOS.getRegistryString((String)String.format("%s/%s", DEVICE_ORDER_REGISTRY_STRING, deviceTypeIndex), (String)"");
        int len = addressString.length();
        long address = Long.parseLong(addressString.substring(0, len - 8), 16);
        address <<= 32;
        return address += Long.parseLong(addressString.substring(len - 8), 16);
    }

    public static int getIndexForAddress(String addressString) {
        String[] externalDeviceOrderKeys;
        for (String externalDeviceKey : externalDeviceOrderKeys = JANOS.getRegistryList((String)DEVICE_ORDER_REGISTRY_STRING)) {
            Matcher match;
            boolean found;
            String deviceOrderRegistryKey = String.format("%s/%s", DEVICE_ORDER_REGISTRY_STRING, externalDeviceKey);
            String addressStringFromRegistry = JANOS.getRegistryString((String)deviceOrderRegistryKey, (String)"");
            if (!addressStringFromRegistry.equalsIgnoreCase(addressString) || !(found = (match = DEVICE_ORDER_PATTERN.matcher(deviceOrderRegistryKey)).find())) continue;
            int index = Integer.valueOf(match.group(2));
            return index;
        }
        return 0;
    }

    @Override
    public void registryModifiedEvent(String registryKey) {
        if (PRESENT_DEVICES_REGISTRY_STRING.equalsIgnoreCase(registryKey)) {
            ThreadElapsed.setStartTime(Thread.currentThread());
            System.out.println(ThreadElapsed.getElapsed() + "present devices changed");
            ExternalDeviceOrder.doRegistryDeviceEnumeration();
            System.out.println(ThreadElapsed.getElapsed() + "doRegistryDeviceEnumeration() complete");
        }
    }

    static {
        RegistryModifiedHandler.addListener(INSTANCE);
        ExternalDeviceOrder.enumerateDevices();
    }
}

