/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio;

import com.integpg.janoslib.externalio.ExternalModule;
import com.integpg.janoslib.externalio.ExternalTemperatureModule;
import com.integpg.janoslib.system.RegistryHelper;
import com.integpg.janoslib.utils.HexUtils;
import com.integpg.sensor.SensorPort;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;

public class Type28
extends ExternalModule
implements ExternalTemperatureModule {
    private double _tempC;
    private double _tempF;

    public static Type28 getByIndex(int index) {
        String typeString = "Type28_" + (index + 1);
        String addressString = JANOS.getRegistryString((String)("externals/deviceorder/" + typeString), null);
        if (null != addressString) {
            if (!ModulesByAddress.containsKey(addressString)) {
                long address = HexUtils.parseHexAsLong(addressString);
                Type28 type28 = new Type28(address);
                type28.TypeIndex = index + 1;
                type28.TypeString = typeString;
                ModulesByAddress.put(addressString, type28);
            }
            return (Type28)ModulesByAddress.get(addressString);
        }
        return null;
    }

    public Type28(long address) {
        super(address);
    }

    @Override
    public long getMinReadInterval() {
        return 1000L;
    }

    @Override
    public double getTempC() {
        return this._tempC;
    }

    @Override
    public double getTempF() {
        return this._tempF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void read() throws Throwable {
        try {
            SensorPort sensorPort = SENSOR_PORT;
            synchronized (sensorPort) {
                this._dataBlock = JANOS.readDeviceBlock((long)this.Address);
                if (this._dataBlock.length != 8) {
                    throw new IOException("Unable to read " + this.AddressString);
                }
            }
            this.LastReadTime = System.currentTimeMillis();
            long longBits = ArrayUtils.getLong((byte[])this._dataBlock, (int)0);
            this._tempC = Double.longBitsToDouble(longBits);
            this._tempF = this._tempC * 9.0 / 5.0 + 32.0;
            if (null != this.TypeString && RegistryHelper.getRegistryKey("Externals/" + this.TypeString + "/UpdateRegistryWithValues", false)) {
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$TempC"), (String)String.valueOf(this._tempC));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$TempF"), (String)String.valueOf(this._tempF));
                JANOS.setRegistryString((String)("Externals/" + this.TypeString + "/$LastReadTime"), (String)QUICK_DATE_FORMAT.format(System.currentTimeMillis()));
            }
        }
        catch (IOException ex) {
            throw new IOException("Error reading temperature module").initCause(ex);
        }
    }

    @Override
    public void commit() {
    }

    @Override
    public void printValues() {
    }

    @Override
    public Object get(String fieldName) {
        if ("tempf".equalsIgnoreCase(fieldName)) {
            return this.getTempF();
        }
        if ("tempc".equalsIgnoreCase(fieldName)) {
            return this.getTempC();
        }
        throw new RuntimeException("Invalid Field Name: " + fieldName);
    }
}

