/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.TextReplacer;
import com.integ.tasker.devices.Device;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.utils.StringUtils;
import java.util.Json;

public class TcpSendMethod
extends Action {
    public TcpSendMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            String message = this._paramsJson.getString("Message");
            message = TextReplacer.replace(message, taskRuntime.Scope);
            byte[] dataBytes = StringUtils.getEscapedBytes(message);
            try {
                if (null == deviceGuid || "".equals(deviceGuid)) {
                    throw new RuntimeException("No device was selected for this TCP Send");
                }
                Device device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                if (null == device) {
                    throw new RuntimeException("No device found for " + deviceGuid);
                }
                if (!(device instanceof EthernetDevice)) {
                    throw new RuntimeException("Device found for " + deviceGuid + " is not an Ethernet Device");
                }
                EthernetDevice ethernetDevice = (EthernetDevice)device;
                try {
                    ethernetDevice.send(dataBytes);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Error sending %s to %s:%d - %s", message, ethernetDevice.getIpAddress(), ethernetDevice.getPort(), ex.getMessage()));
                }
            }
            catch (Exception ex) {
                AppLog.warn(ex.getMessage());
                ErrorMessage errorMessage = new ErrorMessage(ex.getMessage());
                MessagePumpEngine.postMessage(errorMessage.build());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing TCP Send").initCause(ex);
        }
    }
}

