/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.triggers.TriggerEngine;
import com.integ.tasker.triggers.TriggerProfile;
import com.integ.tasker.triggers.TriggerProfilesCollection;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class TriggerConfiguration {
    private static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_triggers.log").setMaxFileSizeInKb(32).setLogType(LogTypes.SingleBak));
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private final TriggerEngine _triggerEngine = new TriggerEngine();

    public TriggerConfiguration(WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public void loadConfiguration(Json[] triggerListJsonArray) throws Throwable {
        if (null == triggerListJsonArray || 0 == triggerListJsonArray.length) {
            return;
        }
        for (Json triggerJson : triggerListJsonArray) {
            LOG.info("triggerJson: " + triggerJson);
        }
        TriggerProfilesCollection.clear();
        for (Json triggerJson : triggerListJsonArray) {
            TriggerProfile triggerProfile = new TriggerProfile(triggerJson);
            TriggerProfilesCollection.put(triggerProfile.Name, triggerProfile);
        }
        this._triggerEngine.updateConfig(triggerListJsonArray, this._workspaceConfigurationFile);
    }
}

