var JnrWebsocket = new JnrWebsocket();


var TaskerApp = angular.module("TaskerApp", ['moment-picker']);

TaskerApp.directive('spinner', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            value: '=',
            min: '@',
            max: '@',
            init: '@',
            roll: '@',
            width: '@'
        },
        link: function ($scope, element, attrs) {
            var spinnerGuid = guid();
            var spinnerId = 'spinner-' + spinnerGuid;
            $scope.init = $scope.init || 0;
            $scope.value = $scope.value || $scope.init;
            $scope.min = $scope.min || 0;
            $scope.roll = $scope.roll || false;

            var html = '<div class="input-group spinner" id="' + spinnerId + '" style="width:{{width}}px;">' +
                '  <input type="number" class="form-control" ng-model=value >' +
                '  <div class="input-group-btn-vertical">' +
                '    <button class="btn btn-default" type="button"><i class="fa fa-caret-up"></i></button>' +
                '    <button class="btn btn-default" type="button"><i class="fa fa-caret-down"></i></button>' +
                '  </div>' +
                '</div>';

            element.html(html).show();
            $compile(element.contents())($scope);

            $('#' + spinnerId + ' .btn:first-of-type').on('click', function () {
                var value = parseInt($('#' + spinnerId + ' input').val());
                if (undefined != $scope.max && $scope.max == value) {
                    if (undefined != $scope.roll && $scope.roll) value = $scope.min;
                } else {
                    value++;
                }
                // if ($scope.max < value) value = $scope.min;
                $('#' + spinnerId + ' input').val(value).trigger('input');
            });
            $('#' + spinnerId + ' .btn:last-of-type').on('click', function () {
                var value = parseInt($('#' + spinnerId + ' input').val());
                if (undefined != $scope.min && $scope.min == value) {
                    if (undefined != $scope.roll && $scope.roll) value = $scope.max;
                } else {
                    value--;
                }
                // if ($scope.min > value) value = $scope.max;
                $('#' + spinnerId + ' input').val(value).trigger('input');
            });

            do_tooltips();
        }
    };
});



TaskerApp.directive('textSelect', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            value: '=',
            index: '@',
            choices: '='
        },
        link: function ($scope, element, attrs) {
            var id = 'displayValue-' + $scope.index;

            var html = ' <div style="position:relative;margin-top:-16px;">\r\n' +
                '    <select class="form-control"\r\n' +
                '        style="position:absolute;top:0px;left:0px;margin:0;padding:0;"\r\n' +
                '        onchange="document.getElementById(\'' + id + '\').value=this.options[this.selectedIndex].text; document.getElementById(\'' + id + '\').value=this.options[this.selectedIndex].value;"\r\n' +
                '        ng-model="value"\r\n' +
                '        ng-options="c.Name as c.Name for c in choices"\r\n' +
                '        data-toggle="tooltip" title="Select a Task that will be executed"\r\n' +
                '        name="schedule-select-taskname-{{index}}" required>\r\n' +
                '    </select>\r\n' +
                '    <input type="text" id="' + id + '" class="form-control"\r\n' +
                '        ng-model="value" placeholder="add/select a value"\r\n' +
                '        onfocus="this.select()"\r\n' +
                '        style="position:absolute;top:0px;left:0px;width:calc(100% - 20px);border-right:0;border-radius:4px 0 0 4px;"\r\n' +
                '        name="schedule-taskname-{{index}}" required>\r\n' +
                '    <input name="idValue" id="idValue" type="hidden">\r\n' +
                '</div>';

            element.html(html).show();
            $compile(element.contents())($scope);

            do_tooltips();
        }
    };
});



function do_tooltips() {
    var tooltips = $('[data-toggle="tooltip"]');
    // console.log(tooltips);
    // tooltips.attr("data-container", "#body");
    // console.log( tooltips );
    // alert(tooltips.length + ' tootltips');
    $('[data-toggle="tooltip"]').tooltip({ delay: 500, container: "body" });
}



toastr.options.positionClass = 'toast-top-right';
toastr.options.positionClass = 'toast-bottom-full-width';
toastr.options.tapToDismiss = false;



function guid() {
    function s4() {
        return Math.floor((1 + Math.random()) * 0x10000)
            .toString(16)
            .substring(1);
    }
    return s4() + s4() + '-' + s4() + '-' + s4() + '-' +
        s4() + '-' + s4() + s4() + s4();
};



function alphanumeric() {
    validate_alphanumeric($(".alphanumeric"));
}



var validate_alphanumeric = function ($elem) {
    if (!$elem) {
        alert('validate_alphanumeric element not found');
    }

    $elem.keypress(function (evt) {
        if (evt.which != 13) {
            var char = String.fromCharCode(evt.which);

            if ('$' == char &&
                (this.selectionStart == 0 || this.selectionStart == 1)) {
                // allow it

            } else {
                // replace a space with and underscore
                var newChar = char.replace(/ /g, '_');

                // remove digits at the beginning of the name
                if (0 == this.selectionStart) {
                    newChar = newChar.replace(/\d/, '');
                }

                // remove all non alphanumeric characters
                newChar = newChar.replace(/([^#a-zA-Z0-9_\-\.])/, '');

                // if the character was nullified then return.  else replace 
                //  the character in the selection range
                if ('' == newChar) return false;
                if (newChar != char) {
                    this.setRangeText(newChar, this.selectionStart, this.selectionEnd, "end");
                    return false;
                }
            }
        }
    });


    $elem.keyup(function (evt) {
        if (evt.which != 13) {
            var char = String.fromCharCode(evt.which);

            if ('$' == char &&
                (this.selectionStart == 0 || this.selectionStart == 1)) {
                // allow it

            } else {
                // replace a space with and underscore
                var newChar = char.replace(/ /g, '_');

                // remove digits at the beginning of the name
                if (0 == this.selectionStart) {
                    newChar = newChar.replace(/\d/, '');
                }

                // remove all non alphanumeric characters
                newChar = newChar.replace(/([^#a-zA-Z0-9_\-\.])/, '');

                // if the character was nullified then return.  else replace 
                //  the character in the selection range
                if ('' == newChar) return false;
                if (newChar != char) {
                    this.setRangeText(newChar, this.selectionStart - 1, this.selectionEnd, "end");
                    return false;
                }
            }
        }
    });
}



var confirm_or_submit_on_enter = function ($elem) {
    var f = function (e) {
        if (e.which == 13) {
            e.preventDefault();
            $("#bootbox-confirm-btn").click();

            // immediately unhook the enter key
            $elem[0].removeEventListener('keyup', f);
            console.log();
        }
    };
    $elem[0].addEventListener('keyup', f);
}



function getNextAvailableName(array, namePrefix) {
    var newName = namePrefix;
    if (!newName.endsWith("_")) newName += "_";
    var index = 1;
    var found = true;
    do {
        found = false;
        array.forEach(function (task) {
            if ((newName + index) == task.Name) {
                found = true;
                index++;
            }
        });
    } while (found);
    newName = newName + index;
    return newName;
}



class TaskerObject {
    constructor() {
        // placing this in the constructor will ensure that every object gets a GUID.  if we are
        // preserving the GUID correctly then we will overwrite this one. if the object was
        // previously assigned one.
        this.GUID = guid();
        this.Params = {};
    }
}




var draggedScope;
var draggedElement;
var dropScope;
var dropTarget;
var _lastDropTarget = null;
var _dragEnabled = false;


var getClosest = function (elem, selector) {
    for (; elem && elem !== document; elem = elem.parentNode) {
        if (elem.matches(selector)) return elem;
    }
    return null;
};



var isDropTargetAChildOfDraggedTarget = function (draggedElement, dropElement) {
    // validate the draggedElement and dropElement
    if (!draggedElement || !dropElement) return false;

    if (draggedElement == dropElement) return true;

    var draggedElementScope = draggedElement.scope();
    var dropElementScope = dropElement.scope();

    if (draggedElementScope.childAction == dropElementScope.action) return true;
    if (draggedElementScope.childAction.actions) {
        draggedElementScope.childAction.actions.forEach(function (childAction) {

        });
    }
};



TaskerApp.directive('draggable', function () {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            index: '='
        },
        link: function (scope, element, attrs) {
            element.attr('draggable', true);
            element.attr('index', scope.index);
            element.addClass('draggable');

            element[0].addEventListener("mousedown", function (event) {
                // console.log("draggable.mousedown");

                var clickedElement = event.target;
                var classList = clickedElement.classList;
                _dragEnabled = (classList.contains("fa-bars"));

                var draggableElement = getClosest(clickedElement, '.draggable');
                if (_dragEnabled) {
                    draggableElement.setAttribute('draggable', _dragEnabled);
                } else {
                    draggableElement.removeAttribute('draggable');
                }
            });

            element[0].addEventListener("dragstart", function (event) {
                // console.log("draggable.dragstart: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                var currentTarget = event.currentTarget;
                var draggableElement = getClosest(currentTarget, '.draggable');
                var draggable = draggableElement.getAttribute('draggable');

                if (draggable && !draggedScope) {
                    draggedScope = scope;
                    draggedElement = angular.element(currentTarget);

                    // make it half transparent
                    event.target.style.opacity = .5;

                    // get the object we are dropping
                    var draggedAction = event.dataTransfer.getData("action");
                    if (!draggedAction) {
                        event.dataTransfer.setData("action", scope.action);

                        // we will allow either a copy or a move.  to copy, the user 
                        // will press and hold the ctrl key
                        event.dataTransfer.effectAllowed = 'copymove';
                    }
                }
            }, false);

            element[0].addEventListener("dragenter", function (event) {
                // console.log("draggable.dragenter: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                // prevent default action
                event.preventDefault();
                event.stopPropagation();

                dropScope = scope;

                dropTarget = event.currentTarget;
                if (typeof dropTarget !== 'undefined' && typeof dropElement !== 'undefined') {
                    if (dropElement && isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {
                        if (!event.ctrlKey && _lastDropTarget) {
                            _lastDropTarget.style['border-top'] = "";
                            _lastDropTarget.style['border-bottom'] = "";
                            _lastDropTarget.style['background'] = "";
                        }
                        return;
                    }

                }

            });

            var nextLogTime = new Date().getTime();
            element[0].addEventListener("dragover", function (event) {
                // if (nextLogTime <= new Date().getTime()) {
                //     console.log("draggable.dragOver: dropEffect = " + event.dataTransfer.dropEffect
                //         + " ; effectAllowed = " + event.dataTransfer.effectAllowed
                //         + " ; ctrlKey = " + event.ctrlKey);
                //     nextLogTime += 1000;
                // }

                // prevent default action as well as propegation
                event.preventDefault();
                event.stopPropagation();

                // check to see if the ctrol key is pressed.  if it is we will change 
                // the effect to indicate that we will copy, or clone the gragged action
                if (event.ctrlKey) {
                    event.dataTransfer.dropEffect = 'copy';
                } else {
                    event.dataTransfer.dropEffect = 'move';
                }

                dropTarget = event.currentTarget;
                if (null != dropTarget) {
                    var dropElement = angular.element(event.currentTarget);

                    if (isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {
                        if (_lastDropTarget) {
                            _lastDropTarget.style['border-top'] = "";
                            _lastDropTarget.style['border-bottom'] = "";
                            _lastDropTarget.style['background'] = "";
                        }
                        return;
                    }

                    var clickedElement = event.target;
                    var classList = clickedElement.classList;
                    var addActionElement = (classList.contains("add-action"));

                    if (event.ctrlKey || (draggedScope && draggedScope.action != dropScope.action)) {
                        var y = event.offsetY;
                        if (y < event.currentTarget.clientHeight / 2) {
                            dropTarget.above = true;
                            dropTarget.below = false;

                            dropTarget.style['border-top'] = "3px solid";
                            dropTarget.style['border-bottom'] = "";

                        } else if (!addActionElement && y >= event.currentTarget.clientHeight / 2) {
                            dropTarget.above = false;
                            dropTarget.below = true;

                            dropTarget.style['border-top'] = "";
                            dropTarget.style['border-bottom'] = "3px solid";

                        }
                    } else {
                        dropTarget.style['border-top'] = "";
                        dropTarget.style['border-bottom'] = "";
                    }
                }

            });


            element[0].addEventListener("dragleave", function (event) {
                // console.log("draggable.dragleave: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                // prevent default action
                event.preventDefault();

                var currentTarget = event.currentTarget;
                // console.log('dragleave currentTarget: ' + currentTarget.innerHTML);
                if (currentTarget && currentTarget != dropTarget) {
                    currentTarget.style['border-top'] = "";
                    currentTarget.style['border-bottom'] = "";
                }
            });

            element[0].addEventListener("dragend", function (event) {
                // console.log("draggable.dragend: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                if (null != dropTarget) {
                    dropTarget.style['border-top'] = "";
                    dropTarget.style['border-bottom'] = "";
                    dropTarget.style['background'] = "";
                }

                _lastDropTarget = null;

                // restore transparency
                if (event.target.style) {
                    event.target.style.opacity = 1;
                }
            });
        }
    };
});



TaskerApp.directive('droppable', function () {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '='
        },
        link: function (scope, element, attrs) {

            element[0].ondragover = function (event) {
                // console.log("droppable.ondragover: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                // prevent default action
                event.preventDefault();
            };


            element[0].onleave = function (event) {
                // console.log("droppable.onleave: dropEffect = " + event.dataTransfer.dropEffect + " ; effectAllowed = " + event.dataTransfer.effectAllowed);

                // prevent default action
                event.preventDefault();
            };


            element[0].ondrop = function (event) {
                // prevent default action
                event.preventDefault();

                if (draggedScope) {
                    // console.log('dropping ' + draggedScope + ' to ' + event.currentTarget.innerText);

                    var draggedElementScope = draggedElement.scope();
                    var draggedActionsList = draggedElementScope.actions;

                    var dropElement = angular.element(event.currentTarget);
                    var dropElementScope = dropElement.scope();
                    var dropActionsList = dropElementScope.actions;

                    var sameTarget = (draggedActionsList == dropActionsList);

                    if (!isDropTargetAChildOfDraggedTarget(draggedElement, dropElement)) {

                        // remove from current position
                        if (!event.ctrlKey) {
                            draggedActionsList.splice(draggedScope.index, 1);
                        }

                        if (sameTarget) {
                            // capture the drop index
                            var dropIndex = dropScope.index;

                            // capture the dragged action.  if it being copied then we need 
                            // to clone the action
                            var draggedAction = draggedScope.action;
                            if (event.ctrlKey) {
                                var newActionCloneString = JSON.stringify(draggedAction, function replacer(key, value) {
                                    if ('GUID' === key) return;
                                    if ('$$hashKey' === key) return;
                                    return value;
                                });
                                draggedAction = JSON.parse(newActionCloneString);
                                draggedAction = parseAction(draggedAction);
                            }

                            // add to new position
                            if (dropIndex < draggedScope.index) {
                                if (dropTarget.above) {
                                    dropActionsList.splice(dropIndex, 0, draggedAction);
                                } else {
                                    dropActionsList.splice(dropIndex + 1, 0, draggedAction);
                                }
                            } else {
                                // if we are copying the action and the new action is 
                                // being added below the original then we must add one 
                                // to the drop index.
                                if (event.ctrlKey) dropIndex++;

                                if (dropTarget.above) {
                                    dropActionsList.splice(dropIndex - 1, 0, draggedAction);
                                } else {
                                    dropActionsList.splice(dropIndex, 0, draggedAction);
                                }
                            }
                        } else {
                            var draggedAction = draggedScope.action;
                            if (event.ctrlKey) {
                                var newActionCloneString = JSON.stringify(draggedAction, function replacer(key, value) {
                                    if ('GUID' === key) return;
                                    if ('$$hashKey' === key) return;
                                    return value;
                                });
                                draggedAction = JSON.parse(newActionCloneString);
                                draggedAction = parseAction(draggedAction);
                            }

                            var index = dropScope.index;
                            if (dropTarget.below) index += 1;
                            // console.log('dropping ' + draggedAction + ' at index ' + index + ", " + dropTarget.below);
                            dropActionsList.splice(index, 0, draggedAction);
                        }
                    }

                    // we are done.  clear our drop effect and nullify our draggedScope 
                    // and dropScope objects
                    if (null != event.dataTransfer) {
                        event.dataTransfer.dropEffect = 'none';
                    }
                    draggedScope = null;
                    dropScope = null;

                    scope.$apply();
                }
            };
        }
    };
});