/* global bootbox, Tasker */

TaskerApp.controller('TasksController', function ($scope, $compile, $location, TaskService, DeviceService) {
    var _this = this;
    _this.ShowDebugDevices = false;



    // watch for changes to our $location.url() object.
    $scope.$watch(function () {
        return $location.url();
    }, function (url) {
        if (url) {
            var taskname = $location.search().taskname;
            if (taskname) {
                // find the task object for the given taskname
                var task = TaskService.TaskList.find(function (element) {
                    if (element.Name == taskname) return element;
                });
                if (task) {
                    _this.selectTask(task);
                }
            }

            var workspaceName = $location.search().workspace;
            if (undefined != workspaceName && _this.Workspace != workspaceName) {
                _this.Workspace = workspaceName;
                JnrWebsocket.readFile('/flash/tasker/workspaces/' + workspaceName, _this.configReceived);
            }
        }
    });



    $scope.$on('workspace.loaded', function (event) {
        var taskName = $location.search().taskname;
        if (taskName) {
            var task = TaskService.TaskList.find(function (element) {
                if (element.Name == taskName) return element;
            });
            if (task) _this.selectTask(task);
        }
    });



    _this.getDeviceProfiles = function () {
        return DeviceService.DeviceList;
    };



    _this.getSNMPDevices = function () {
        return DeviceService.DeviceList.filter(function (element) {
            return 'SNMPDevice' === element.Type;
        });
    };



    _this.getSNMPTypes = function () {
        return ["integer", "string"];
    };



    _this.getModbusDevices = function () {
        return DeviceService.DeviceList.filter(function (element) {
            return 'ModbusDevice' === element.Type;
        });
    };



    _this.areTasksLoaded = function () {
        return TaskService.TasksLoaded;
    };



    _this.getTasks = function () {
        return TaskService.TaskList;
    };



    _this.selectTask = function (task) {
        var form = $("#tasks-form");
        form.validate({ errorPlacement: function (error, element) { } });

        if (form.valid()) {
            TaskService.SelectedTask = task;
            if (null != task) $location.search('taskname', task.Name);
            else $location.search('taskname', '');

            $('html, body').animate({
                scrollTop: $('#tasks-form').offset().top - 125
            }, 300);
        } else {
            bootbox.alert({
                title: 'Validation Error',
                message: 'There was an error validating this task.  Please check the fields in red and try again'
            }).init(function () {
                $(".modal-header").css("background-color", "#f0ad4e");
                $(".modal-header").css("color", "#fff");
            });
        }
    };


    _this.getSelectedTask = function () {
        return TaskService.SelectedTask;
    };



    _this.moveTaskUp = function (task, currentIndex) {
        // remove from current position
        TaskService.TaskList.splice(currentIndex, 1);

        // assign the task to the previous position 
        TaskService.TaskList.splice(currentIndex - 1, 0, task);
    };



    _this.moveTaskDown = function (task, currentIndex) {
        // remove from current position
        TaskService.TaskList.splice(currentIndex, 1);

        // assign the task to the previous position 
        TaskService.TaskList.splice(currentIndex + 1, 0, task);

    };



    _this.addTask = function () {
        bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {

                    if (undefined == TaskService.TaskList) TaskService.TaskList = [];
                    var task = new Task(result, true);
                    task.Action = new ControlFunction();
                    TaskService.TaskList.push(task);

                    _this.selectTask(task);

                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_on_enter($(".bootbox-input"));
        });
    };



    _this.editTaskName = function (task) {
        bootbox.prompt({
            title: "Edit the name of the Task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: task.Name,
            callback: function (result) {
                if (result) {

                    task.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            confirm_on_enter($(".bootbox-input"));

            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.removeTask = function (task) {
        bootbox.confirm({
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + task.Name + "' task?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = TaskService.TaskList.indexOf(task);
                    if (-1 != index) {
                        TaskService.TaskList.splice(index, 1);
                    }
                    _this.selectTask(null);

                    $scope.$apply();
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#f0ad4c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.removeAction = function (actions, action) {
        if (undefined !== actions) {
            var index = actions.indexOf(action);
            if (-1 !== index) {
                actions.splice(index, 1);
            }
        }
    };



    _this.removeActionFromTask = function (task, action) {
        bootbox.confirm({
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + action.Abbrv + "." + action.Method + "' action?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = task.Actions.indexOf(action);
                    if (-1 != index) {
                        task.Actions.splice(index, 1);
                    }

                    $scope.$apply();
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#f0ad4c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.resetAction = function (action) {
        action.Method = undefined;
    };



    _this.resetActionParams = function (action) {
        action.Params = {};
    };



    _this.executeTask = function (task) {
        JnrWebsocket.postMessage(2010, { Message: 'task.execute', TaskName: task.Name });
    };



    _this.addAction = function (newAction) {
        switch (newAction) {
            // OTHER
            case 'Comment':
                newAction = new Comment("some comment");
                break;

            case 'CommandLine':
                newAction = new CommandLine();
                break;

            case 'Reboot':
                newAction = new Reboot();
                break;

            case 'ExecTask':
                newAction = new ExecTask();
                break;

            case 'CancelTask':
                newAction = new CancelTask();
                break;

            case 'ExecScript':
                newAction = new ExecScript();
                break;

            case 'UserAlert':
                newAction = new UserAlert();
                break;

            case 'FileDelete':
                newAction = new FileDelete();
                break;

            case 'FilePrepend':
                newAction = new FilePrepend();
                break;

            case 'FileMove':
                newAction = new FileMove();
                break;

            case 'FileCopy':
                newAction = new FileCopy();
                break;


            // RELAY OUTPUTS
            case 'CloseRelay':
                newAction = new CloseRelay();
                break;

            case 'OpenRelay':
                newAction = new OpenRelay();
                break;

            case 'SetRelayState':
                newAction = new SetRelayState();
                break;

            case 'PulseRelay':
                newAction = new PulseRelay();
                break;

            case 'SetBlock':
                newAction = new SetBlock();
                break;

            case 'PulseBlock':
                newAction = new PulseBlock();
                break;

            case 'RoutResetUsageMeter':
                newAction = new RoutResetUsageMeter();
                break;

            // DIGITAL INPUT ACTIONS
            case 'SoftInvert':
                newAction = new DinSoftInvert();
                break;

            case 'SetCounter':
                newAction = new DinSetCounter();
                break;

            case 'DinResetUsageMeter':
                newAction = new DinResetUsageMeter();
                break;

            case 'DinClearLatch':
                newAction = new DinClearLatch();
                break;

            // ANALOG OUTPUT
            case 'Set10vPercent':
                newAction = new Set10vPercent();
                break;

            case 'Set10vVoltage':
                newAction = new Set10vVoltage();
                break;

            case 'Set420maPercent':
                newAction = new Set420maPercent();
                break;

            case 'Set420maAmps':
                newAction = new Set420maAmps();
                break;

            // CONTROL PANEL
            case 'SetLed':
                newAction = new SetLed();
                break;

            case 'PlayAlarm':
                newAction = new PlayAlarm();
                break;

            case 'SilenceAlarm':
                newAction = new SilenceAlarm();
                break;

            case 'OnSwitchTrigger':
                newAction = new OnSwitchTrigger();
                break;

            case 'OnMultiSwitchTrigger':
                newAction = new OnMultiSwitchTrigger();
                break;



            // Timing
            case 'SleepAction':
                newAction = new SleepAction();
                break;



            // Control Structures
            case 'ForLoop':
                newAction = new ForLoop();
                break;

            case 'IfBlock':
                newAction = new IfBlock();
                break;

            case 'IfElseBlock':
                newAction = new IfElseBlock();
                break;

            case 'WhileLoop':
                newAction = new WhileLoop();
                break;

            case 'SetVariable':
                newAction = new SetVariable();
                break;



            // LIGHTING
            case 'SetLEDChannel':
                newAction = new SetLEDChannel();
                break;

            case 'SetLEDRGB':
                newAction = new SetLEDRGB();
                break;

            case 'FadeLEDChannel':
                newAction = new FadeLEDChannel();
                break;

            case 'FadeLEDRGB':
                newAction = new FadeLEDRGB();
                break;


            // LOGGING
            case 'LogEntry':
                newAction = new LogEntry();
                break;

            case 'LogProfile':
                newAction = new LogProfile();
                break;


            // NETWORK
            case 'DeviceSend':
                newAction = new DeviceSend();
                break;

            case 'TcpSend':
                newAction = new TcpSend();
                break;

            case 'TcpRecv':
                newAction = new TcpRecv();
                break;

            case 'TcpClose':
                newAction = new TcpClose();
                break;

            case 'EmailEntry':
                newAction = new EmailEntry();
                break;

            case 'EmailProfile':
                newAction = new EmailProfile();
                break;

            case 'SNMPTrap':
                newAction = new SNMPTrap();
                break;

            case 'SNMPSet':
                newAction = new SNMPSet();
                break;

            case 'MQTTPublish':
                newAction = new MQTTPublish();
                break;

            case 'HTTPGet':
                newAction = new HTTPGet();
                break;

            case 'HTTPPost':
                newAction = new HTTPPost();
                break;
        }

        // _this.selectedActionsBlock.addAction(newAction);
        _this.selectedActionsBlock.push(newAction);

        _this.addActionDialog.modal('hide');
        _this.ShowDebugDevices = false;
    };


    _this.showAddToActionsDialog = function (actionsBlock, $event) {
        var template = '<div ng-include="\'tasks/new-actions-3.html\'"></div>';
        if ($event.shiftKey) {
            // template = '<div ng-include="\'tasks/new-actions-2.html\'"></div>';
        } else if ($event.ctrlKey) {
            _this.ShowDebugDevices = true;
            // template = '<div ng-include="\'tasks/new-actions.html\'"></div>';
        }


        var linkFn = $compile(template);
        var html = linkFn($scope);

        _this.selectedActionsBlock = actionsBlock;
        _this.addActionDialog = bootbox.dialog({
            // className: 'fullscreen bb-primary',
            className: 'bb-primary',
            title: "Add Action",
            message: html,
            // size: 'large',
            onEscape: function () {
                _this.addActionDialog.modal('hide');
                _this.ShowDebugDevices = false;
            }
        });
        _this.addActionDialog.init(function () {
            $compile(_this.addActionDialog.contents())($scope);
        });
    };



    _this.showIfHelp = function () {
        bootbox.dialog({
            className: 'bb-primary',
            title: "If/Then Help",
            message: '<h3>Available conditionals</h3>\r\n' +
                '<p>\r\n' +
                '  <h4>Internal I/O</h4>\r\n' +
                '  <code>din[#].state == 1</code><br>\r\n' +
                '  <code>rout[#].state == 1</code><br>\r\n' +
                '  <h4>Temperature and Environmental I/O</h4>\r\n' +
                '  <code>temp[#].f >= 75</code> or <code>temp[#].fahrenheit >= 75</code><br>\r\n' +
                '  <code>temp[#].c >= 20</code> or <code>temp[#].celsius >= 20</code><br>\r\n' +
                '  <code>env[#].f >= 75</code> or <code>env[#].fahrenheit >= 75</code><br>\r\n' +
                '  <code>env[#].c >= 20</code> or <code>env[#].celsius >= 20</code><br>\r\n' +
                '  <code>env[#].humidity >= 80</code>\r\n' +
                '  <h4>Validate Days of the Week</h4>\r\n' +
                '  <code>date.isDay(montuewedthufri)</code><br>\r\n' +
                '  <code>date.isDay(satsun)</code><br>\r\n' +
                '  <h4>Validate Time of Day</h4>\r\n' +
                '  <code>time.before(HH:MM)</code><br>\r\n' +
                '  <code>time.after(HH:MM)</code><br>\r\n' +
                '</p>',
            backdrop: true,
            onEscape: function () {
                this.modal('hide');
            }
        });
    };
});



/*
   SERVICE
*/
TaskerApp.service('TaskService', function ($rootScope, DeviceService) {
    var _this = this;
    _this.TaskList = [];
    _this.SelectedTask = null;
    _this.TasksLoaded = false;



    _this.load = function (taskListJson) {
        if (undefined == taskListJson) taskListJson = [];

        try {
            parseTaskList(taskListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedTask = null;
        _this.TasksLoaded = true;

        return _this.TaskList;
    };



    function parseTaskList(taskArray) {
        // empty our array of tasks
        _this.TaskList = [];

        taskArray.forEach(function (taskJson) {
            if (undefined == taskJson.Enabled) taskJson.Enabled = true;
            var task = new Task(taskJson.Name, taskJson.Enabled);

            // parse the task base action
            var action = parseAction(taskJson.Action);
            if (taskJson.GUID) {
                task.GUID = taskJson.GUID;
            }
            task.Action = action;
            // successful task.  push it to our array of tasks
            _this.TaskList.push(task);
        });
    }



    _this.validate = function () {
        var form = $("#tasks-form");
        form.validate({ errorPlacement: function (error, element) { } });
        return form.valid();
    };
});







TaskerApp.directive('actionBlock', function ($compile) {
    return {
        restrict: 'E', // element
        scope: {
            action: '=',
            parent: '=',
            actions: '=',
            controller: '='
        },
        link: function (scope, element, attrs) {
            var html = '<ul droppable action="action" style="min-height: 12px; padding:8px;">\r\n' +
                '<li ng-repeat="childAction in actions" draggable action="childAction" index="$index" style="list-style:none; padding-bottom:0;">\r\n' +
                '  <div action-div action="childAction" level="0" parent="action" actions="actions" controller="controller" style="min-height: 42px; padding: 4px;"></div>\r\n' +
                '</li>\r\n' +
                '<li draggable ng-if="0 == actions.length" class="add-action" style="list-style:none; padding-bottom:0;">Drag an Action or click Add Action to add an Action to this Task</li>\r\n' +
                '</ul>\r\n' +
                '<a href="javascript: void(0)" ng-click="controller.showAddToActionsDialog(actions, $event)" class="text-success">\r\n' +
                '  <i class="fa fa-plus" aria-hidden="true"></i> Add Action</a>';

            element.html(html).show();
            $compile(element.contents())(scope);
        }
    };
});



TaskerApp.directive('actionDiv', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            level: '=',
            parent: '=',
            controller: '=',
            actions: '='
        },
        link: function (scope, element, attrs) {
            scope.index++;

            var html = '<i class="fa fa-bars" style="margin-right: 12px"></i>\r\n' +
                '<a href="javascript: void(0)" ng-click="controller.removeAction(actions, action)" class="text-danger"><i class="fa fa-trash" aria-hidden="true"></i></a> \r\n' +
                '<span>&nbsp;&nbsp;</span>\r\n' +
                '<span action-edit action="action" controller="controller" class="form-inline"></span>\r\n';

            html += scope.action.getAdditionalHtml();

            element.html(html).show();
            $compile(element.contents())(scope);
        }
    };
});



TaskerApp.directive('actionEdit', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            action: '=',
            controller: '='
        },
        link: function ($scope, element, attrs) {
            element.html($scope.action.editTemplate()).show();
            $compile(element.contents())($scope);

            $('[data-toggle="tooltip"]').tooltip();

            preventSpaces();
        }
    };
});