/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers.triggertypes;

import com.integ.tasker.IOMonitors;
import com.integ.tasker.Unloadable;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integ.tasker.triggers.Trigger;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.iolog.IoChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import java.util.Json;

public class DiscreteSignalTrigger
extends Trigger
implements IoChannelLogListener,
Unloadable {
    private final Json _paramsJson;
    private final String _signalProfileName;
    private final String _triggerState;
    private SignalProfile _signalProfile;

    public DiscreteSignalTrigger(Json triggerJson) {
        this._paramsJson = (Json)triggerJson.get("Params");
        this._triggerState = this._paramsJson.getString("State");
        Json triggerSignalJson = (Json)this._paramsJson.get("Signal");
        System.out.println("_triggerSignalJson: " + triggerSignalJson);
        this._signalProfileName = triggerSignalJson.getString("Name");
        this._scope.setVariable("trigger.signalname", this._signalProfileName);
    }

    @Override
    public void setWorkspaceConfigurationFile(WorkspaceFile workspaceConfigurationFile) {
        super.setWorkspaceConfigurationFile(workspaceConfigurationFile);
        this._workspaceConfigurationFile.addUnloadable(this);
        System.out.println("DiscreteSignalTrigger._signalProfileName: " + this._signalProfileName);
        SignalProfilesCollection signalProfilesCollection = workspaceConfigurationFile.getSignalProfilesCollection();
        this._signalProfile = signalProfilesCollection.getByName(this._signalProfileName);
        System.out.println("signalProfilesCollection = " + signalProfilesCollection);
        System.out.println("_signalProfile.DeviceType: " + this._signalProfile.DeviceType);
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.addDigitalInputListener(this._signalProfile.Channel, this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.addDigitalOutputListener(this._signalProfile.Channel, this);
        }
    }

    @Override
    public void unload() {
        System.out.println("_signalProfile.DeviceType: " + this._signalProfile.DeviceType);
        if ("din".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.removeDigitalInputListener(this._signalProfile.Channel, this);
        } else if ("rout".equalsIgnoreCase(this._signalProfile.DeviceType)) {
            IOMonitors.removeDigitalOutputListener(this._signalProfile.Channel, this);
        }
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        long timeBehind = System.currentTimeMillis() - ioEvent.TransitionTime;
        if (15000L < timeBehind) {
            return;
        }
        System.out.println(String.format("timeBehind: %lld", timeBehind));
        if (-1 == this._signalProfile.Channel || ioEvent.Channel == this._signalProfile.Channel) {
            System.out.println(String.format("Discrete Trigger Channel: %d, Channel Changed: %d", this._signalProfile.Channel, ioEvent.Channel));
            System.out.println(String.format("Discrete Trigger Trigger State: %s, IO State: %s", String.valueOf(this._triggerState), String.valueOf(ioEvent.State)));
            boolean triggered = false;
            if ("either".equalsIgnoreCase(this._triggerState)) {
                triggered = true;
            } else if (ioEvent.State && "high".equalsIgnoreCase(this._triggerState)) {
                triggered = true;
            } else if (!ioEvent.State && "low".equalsIgnoreCase(this._triggerState)) {
                triggered = true;
            }
            if (triggered) {
                this._scope.setVariable("trigger.state", ioEvent.State);
                this.trigger();
            }
        }
    }
}

