var Loader = function() {
};
Loader.prototype = {
    require: function(scripts, callback) {
        this.loadCount = 0;
        this.totalRequired = scripts.length;
        this.callback = callback;

        for (var i = 0; i < scripts.length; i++) {
            this.writeScript(scripts[i]);
        }
    },
    loaded: function(evt) {
        this.loadCount++;
        this.callback.call(undefined, this.loadCount, this.totalRequired);
    },
    writeScript: function(src) {
        var self = this;
        var fileExtension = src.substring(src.lastIndexOf(".") + 1);
        if (fileExtension == "js") { //if filename is a external JavaScript file
//            var fileref = document.createElement('script')
//            fileref.setAttribute("type", "text/javascript")
//            fileref.setAttribute("src", src)

            var s = document.createElement('script');
            s.type = "text/javascript";
            s.async = false;
            s.src = src;
            s.addEventListener('load', function(e) {
                self.loaded(e);
            }, false);
            var head = document.getElementsByTagName('head')[0];
            head.appendChild(s);
        }
        else if (fileExtension == "css") { //if filename is an external CSS file
//            var fileref = document.createElement("link")
//            fileref.setAttribute("rel", "stylesheet")
//            fileref.setAttribute("type", "text/css")
//            fileref.setAttribute("href", src)

            var s = document.createElement('link');
            s.type = "text/css";
            s.rel = "stylesheet";
            s.async = false;
            s.href = src;
            s.addEventListener('load', function(e) {
                self.loaded(e);
            }, false);
            var head = document.getElementsByTagName('head')[0];
            head.appendChild(s);
        }
    }
};