/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.triggers.TriggerMonitor;
import com.integpg.janoslib.io.AppLog;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Json;

public class TriggerEngine {
    private Json[] _configJson;
    private Hashtable<String, TriggerMonitor> _triggers = new Hashtable();

    public void updateConfig(Json[] jsonConfig, WorkspaceConfigurationFile workspaceConfigurationFile) {
        Object triggerName;
        this._configJson = jsonConfig;
        System.out.println("Trigger Json Config: " + this._configJson.toString());
        if (null == jsonConfig) {
            return;
        }
        ArrayList<Json[]> currentSignalNames = new ArrayList<Json[]>();
        Enumeration<String> e = this._triggers.keys();
        while (e.hasMoreElements()) {
            triggerName = e.nextElement();
            currentSignalNames.add((Json[])triggerName);
            TriggerMonitor triggerMonitor = this._triggers.get(triggerName);
            triggerMonitor.stop();
        }
        for (Json signalJson : this._configJson) {
            String name = signalJson.getString("Name");
            System.out.println("name: " + name);
            try {
                TriggerMonitor triggerMonitor;
                if (!this._triggers.containsKey(name)) {
                    AppLog.info("Create trigger monitor: " + name);
                    triggerMonitor = new TriggerMonitor(signalJson, workspaceConfigurationFile);
                    this._triggers.put(name, triggerMonitor);
                    continue;
                }
                AppLog.info("Update trigger monitor: " + name);
                triggerMonitor = this._triggers.get(name);
                triggerMonitor.updateConfig(signalJson);
                currentSignalNames.remove(name);
            }
            catch (Exception ex) {
                AppLog.error("Error loading trigger for " + name, ex);
            }
        }
        for (String string : currentSignalNames) {
            TriggerMonitor triggerMonitor = this._triggers.get(string);
            triggerMonitor.stop();
            this._triggers.remove(string);
        }
        e = this._triggers.keys();
        while (e.hasMoreElements()) {
            triggerName = e.nextElement();
            TriggerMonitor triggerMonitor = this._triggers.get(triggerName);
            triggerMonitor.start();
        }
    }
}

