/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.net.http.server;

import com.integpg.janoslib.logging.AppLog;
import com.integpg.janoslib.net.http.HttpConnection;
import com.integpg.janoslib.net.http.server.HttpContext;
import com.integpg.janoslib.net.http.server.HttpListener;
import com.integpg.janoslib.net.http.server.HttpRequest;
import com.integpg.janoslib.net.http.server.HttpServer;
import com.integpg.janoslib.net.http.server.WebHandler;
import java.util.Hashtable;

public class WebHandlerServer
implements HttpListener {
    private Hashtable<String, WebHandler> _webHandlers = new Hashtable();
    private HttpServer _httpServer;

    public void addWebHandler(String resource, WebHandler webHandler) {
        this._webHandlers.put(resource.toLowerCase(), webHandler);
    }

    public void start(int port) {
        this._httpServer = new HttpServer(port);
        this._httpServer.addListener(this);
        this._httpServer.start();
        AppLog.info("WebServer started on port " + port);
    }

    @Override
    public void requestRecieved(HttpRequest httpRequest) {
        try {
            HttpContext httpContext = new HttpContext(httpRequest);
            if (!"GET".equalsIgnoreCase(httpRequest.getRequestType())) {
                this._httpServer.getLog().warn("unknown request type: " + httpRequest.getRequestType());
                HttpConnection httpConnection = httpRequest.getHttpConnection();
                httpConnection.getHttpServer().blocklistHostAddress(httpConnection.getRemoteAddress());
            } else {
                String requestedResource = httpRequest.getRequestedResource();
                if (null == requestedResource) {
                    requestedResource = "";
                }
                if (this._webHandlers.containsKey(requestedResource = requestedResource.toLowerCase())) {
                    try {
                        WebHandler webHandler = this._webHandlers.get(requestedResource);
                        webHandler.processRequest(httpContext);
                        httpContext.getResponse().sendResponse(200);
                    }
                    catch (Exception ex) {
                        ex.printStackTrace(httpContext.getResponse().getWriter());
                        httpContext.getResponse().sendResponse(500);
                    }
                } else {
                    httpContext.getResponse().sendResponse(404);
                    httpRequest.close();
                    if (!"/favicon.ico".equalsIgnoreCase(requestedResource)) {
                        this._httpServer.getLog().warn("unknown resource: " + httpRequest.getRequestedURI());
                        HttpConnection httpConnection = httpRequest.getHttpConnection();
                        httpConnection.getHttpServer().blocklistHostAddress(httpConnection.getRemoteAddress());
                    }
                }
            }
            httpRequest.close();
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }
}

