
/*
   SERVICE
*/
TaskerApp.service('DevicesService', function ($rootScope) {
    var _this = this;

    _this.DevicesInfo = [
        {
            Name: "Digital Input States", Type: "DIN", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], Variables: [
                // { Name: "Timestamp", Type: "Timestamp", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH" },
                { Name: "State", Type: "State", Options: ["High", "Low"], Comparators: ["="] }
                // { Name: "Counter", Type: "Counter", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH", Disabled: true },
                // { Name: "Usage Meters", Type: "Usage Meters", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH", Disabled: true }
            ]
        },
        {
            Name: "Relay Output States", Type: "ROUT", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16], Variables: [
                { Name: "State", Type: "State", Options: ["High", "Low", "Either"], Comparators: ["="] }
                // { Name: "Usage Meters", Type: "Usage Meters", Options: ["High", "Low"], Comparators: ["<", "<=", "=", ">=", ">"], Value: "HIGH", Disabled: true }
            ]
        },

        {
            Name: "Temperature Probe", Type: "Type28", Channels: [1, 2], Variables: [
                { Name: "Celsius", Type: "TempC", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Fahrenheit", Type: "TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
            ]
        },

        {
            Name: "Environmental Sensor", Type: "Type7E", Channels: [1, 2], Variables: [
                { Name: "Celsius", Type: "TempC", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Fahrenheit", Type: "TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Humidity", Type: "Humidity", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
                //                {Name: "Pressure In Hg", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
                //                {Name: "Pressure Millibars", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
                //                {Name: "Dew Point C", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
                //                {Name: "Dew Point F", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
                //                {Name: "Heat Index C", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]},
                //                {Name: "Heat Index F", Type: "Type7E.TempF", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"]}
            ]
        },

        {
            Name: "4 - 20 ma Module Inputs", Type: "IIN", Channels: [1, 2, 3, 4], Variables: [
                { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Scaled Value", Type: "Scaled", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
            ]
        },

        {
            Name: "4 - 20 ma Module Outputs", Type: "IOUT", Channels: [1, 2], Variables: [
                { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Scaled Value", Type: "Scaled", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
            ]
        },

        {
            Name: "10 volt Module Inputs", Type: "VIN", Channels: [1, 2, 3, 4], Variables: [
                { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Scaled Value", Type: "Scaled", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
            ]
        },

        {
            Name: "10 volt Module Outputs", Type: "VOUT", Channels: [1, 2], Variables: [
                { Name: "Raw Value", Type: "Raw", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] },
                { Name: "Scaled Value", Type: "Scaled", Options: ["Value"], Comparators: ["<", "<=", "=", ">=", ">"] }
            ]
        },

        {
            Name: "Control Panel", Type: "CTRLPNL", Channels: [1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12], Variables: [
                { Name: "Switch", Type: "State", Options: ["Press"] }
            ]
        }
    ];



    _this.getDeviceInfoByType = function (type) {
        for (var i = 0; i < _this.DevicesInfo.length; i++) {
            if (type === _this.DevicesInfo[i].Type) {
                return _this.DevicesInfo[i];
            }
        }
        return null;
    };
});