/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.identifierobjects;

import com.integ.tasker.identifierobjects.IdentifierObject;
import com.integpg.janoslib.datastructures.Queue;
import com.integpg.janoslib.debug.DEBUG;
import com.integpg.janoslib.lexer.Lexer;
import com.integpg.janoslib.lexer.Token;
import com.integpg.janoslib.lexer.TokenStream;

public class Identifier {
    private final String _identifierString;

    public Identifier(String identifierString) {
        this._identifierString = identifierString;
    }

    public Object evaluate() {
        DEBUG.throwException("Should not get here");
        System.out.println("Identifier.evaluate(): " + this._identifierString);
        long start = System.currentTimeMillis();
        try {
            Queue<Token> tokenQueue = new Queue<Token>();
            Lexer.parse(tokenQueue, this._identifierString);
            TokenStream tokens = new TokenStream(tokenQueue);
            Token currentToken = tokens.getCurrent();
            if (0 != currentToken.type) {
                throw new RuntimeException("device identifier expected.  found " + currentToken + " instead");
            }
            String identifierNameString = currentToken.content;
            System.out.println("identifierNameString: " + identifierNameString);
            IdentifierObject identifierObject = IdentifierObject.getIdentifierObject(identifierNameString);
            if (null == identifierObject) {
                throw new RuntimeException("unknown identifier object for " + identifierNameString);
            }
            currentToken = tokens.nextToken();
            if (91 == currentToken.type) {
                currentToken = tokens.nextToken();
                if (3 != currentToken.type) {
                    throw new RuntimeException("channel expected.  found " + currentToken + " instead");
                }
                int channel = Integer.parseInt(currentToken.content);
                identifierObject.setChannel(channel);
                currentToken = tokens.nextToken();
                if (93 != currentToken.type) {
                    throw new RuntimeException("']' expected.  found " + currentToken + " instead");
                }
                currentToken = tokens.nextToken();
            }
            if (46 != currentToken.type) {
                throw new RuntimeException("'.' expected.  found " + currentToken + " instead");
            }
            currentToken = tokens.nextToken();
            String fieldOrMethod = currentToken.content;
            if (!tokens.isEmpty()) {
                currentToken = tokens.nextToken();
                if (40 == currentToken.type) {
                    System.out.println("parens: " + currentToken);
                    int rightParenIndex = this._identifierString.lastIndexOf(")");
                    String params = this._identifierString.substring(currentToken.colPos + 1, rightParenIndex);
                    System.out.println("params: " + params);
                    identifierObject.setMethod(fieldOrMethod, params);
                }
            } else {
                identifierObject.setField(fieldOrMethod);
            }
            return identifierObject.evaluate();
        }
        catch (Exception ex) {
            ex.printStackTrace();
            long elapsed = System.currentTimeMillis() - start;
            System.out.println("ASTDeviceIdentifier elapsed2: " + elapsed);
            return null;
        }
    }

    public String toString() {
        return this.getClass() + ":" + this._identifierString;
    }
}

