/* global bootbox, Tasker */

TaskerApp.controller('DevicesController', function ($scope, $compile, DeviceService) {
    var _this = this;



    _this.areDevicesLoaded = function () {
        return DeviceService.DevicesLoaded;
    };



    _this.getDevices = function () {
        return DeviceService.DeviceList;
    };



    _this.selectDevice = function (device) {
        DeviceService.SelectedDevice = device;
    };



    _this.getSelectedDevice = function () {
        return DeviceService.SelectedDevice;
    };



    _this.addDevice = function () {
        bootbox.dialog({
            title: "Create a new Device",
            message: '<form id="device-form"><p>What is the name of the new Device? <input type="text" id="device-name" class="form-control"></p>' +
                '<p>What is the new Device Type <select id="device-type" class="form-control">' +
                '  <option>Ethernet Device</option>' +
                '  <option>SNMP Device</option>' +
                '</select></form>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'OK',
                    className: 'btn-success',
                    callback: function (result) {
                        var form = $("#device-form");
                        form.validate({ errorPlacement: function (error, element) { } });

                        if (form.valid()) {
                            var nameElement = form.find('#device-name');
                            var name = nameElement.val();
                            var typeElement = form.find('#device-type');
                            var type = typeElement.children("option:selected").val();
                            var device = null;
                            switch (type) {
                                case 'Ethernet Device':
                                    device = new EthernetDevice(name);
                                    break;

                                case 'SNMP Device':
                                    device = new SNMPDevice(name);
                                    break;
                            }

                            if (null != device) {
                                if (undefined == DeviceService.DeviceList) DeviceService.DeviceList = [];
                                DeviceService.DeviceList.push(device);
                            }

                            $scope.$apply();
                        } else return false;
                    }
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.editDeviceName = function (device) {
        bootbox.prompt({
            title: "Edit the name of the Device?",
            message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
                ' Device can have negative consequences if it it referenced elsewhere in Tasker. ' +
                ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: device.Name,
            callback: function (result) {
                if (result) {
                    device.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.removeDevice = function (device) {
        bootbox.confirm({
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + device.Name + "' device?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = DeviceService.DeviceList.indexOf(device);
                    if (-1 != index) {
                        DeviceService.DeviceList.splice(index, 1);
                    }

                    $scope.$apply();
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#f0ad4c");
            $(".modal-header").css("color", "#fff");
        });
    };
});



/*
   SERVICE
*/
TaskerApp.service('DeviceService', function ($rootScope) {
    var _this = this;
    _this.DeviceList = [];
    _this.SelectedDevice = null;
    _this.DevicesLoaded = false;



    _this.load = function (deviceListJson) {
        if (undefined == deviceListJson) deviceListJson = [];

        try {
            parseDeviceList(deviceListJson);
        } catch (err) {
            console.error(err);
        }

        _this.SelectedDevice = null;
        _this.DevicesLoaded = true;

        return _this.DeviceList;
    };



    function parseDeviceList(deviceArray) {
        // empty our array of devices
        _this.DeviceList = [];

        deviceArray.forEach(function (deviceJson) {
            var device = null;
            switch (deviceJson.Type) {
                case 'EthernetDevice':
                    device = new EthernetDevice(deviceJson.Name);
                    break;

                case 'SNMPDevice':
                    device = new SNMPDevice(deviceJson.Name);
                    break;

            }
            device.Params = deviceJson.Params;
            device.GUID = deviceJson.GUID;
            _this.DeviceList.push(device);
        });
    }



    _this.validate = function () {
        var form = $("#devices-form");
        form.validate({ errorPlacement: function (error, element) { } });
        return form.valid();
    };
});



TaskerApp.directive('deviceEdit', function ($compile) {
    return {
        restrict: 'A', // attribute
        scope: {
            device: '=',
        },
        link: function ($scope, element, attrs) {
            var template = $scope.device.editTemplate();
            element.html(template).show();
            $compile(element.contents())($scope);

            $('[data-toggle="tooltip"]').tooltip();
        }
    };
});