/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.externalio.controlpanel;

import com.integpg.janoslib.externalio.controlpanel.ControlPanelListener;
import com.integpg.janoslib.logging.AppLog;
import com.integpg.system.ArrayUtils;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.ArrayList;

public class ControlPanel
implements Runnable {
    private static ControlPanel INSTSANCE = null;
    private static final byte LED_SELECT_MASK_POS = 0;
    private static final byte LED_STATE_POS = 2;
    private static final byte FLASH_RATE_POS = 4;
    private static final byte FLASH_COUNT_POS = 5;
    private static final byte SWITCH_ACK_POS = 6;
    private static final byte SWITCH_RESET_POS = 8;
    private static final byte COMMAND_POS = 10;
    private static final byte COMMAND_PARAMETER_POS = 11;
    private static final byte TONE_FREQUENCY_POS = 12;
    private static final byte TONE_COUNT_POS = 13;
    private static final byte TONE_LENGTH_POS = 14;
    private static final byte PERIOD_POS = 16;
    private static final byte ALARM_DURATION_POS = 18;
    private static final byte BLOCK_SIZE = 20;
    public static final byte LED_OFF = -1;
    public static final byte LED_ON = 0;
    public static final byte FLASH_SLOW = 1;
    public static final byte FLASH_MEDIUM = 2;
    public static final byte FLASH_FAST = 3;
    public static final byte FLASH_CONTINUOUS = 0;
    public static final byte NO_COMMAND = 0;
    public static final byte RESET = 1;
    public static final byte SET_PANEL_BRIGHTNESS = 2;
    public static final byte PLAY_SOUND = 3;
    public static final byte SET_AUDIO_VOLUME = 4;
    public static final byte SOUND_ALARM = 5;
    public static final byte SILENCE_ALARM = 6;
    private Thread _thd = null;
    private int _monitorRate = 250;
    private ArrayList<ControlPanelListener> _listeners = new ArrayList();
    private final byte[] _writeBlock = new byte[20];
    private int[] _switchPresses = new int[12];
    private int _leds = 0;
    private int _ledsMask = 0;
    private boolean _checkLeds = true;
    private int _onMask = 0;
    private int _slowFlashMask = 0;
    private int _medFlashMask = 0;
    private int _fastFlashMask = 0;
    private int _ignoreMask = 0;
    private int _panelCount = 0;
    private long[] _panels = null;
    private final Object _oneWireLock = new Object();

    public static final ControlPanel getInstance() {
        if (null == INSTSANCE) {
            INSTSANCE = new ControlPanel();
        }
        return INSTSANCE;
    }

    public long[] getPanels() {
        return this._panels;
    }

    public int getPanelCount() {
        return this._panelCount;
    }

    public ControlPanel enumeratePanels() {
        try {
            int i;
            this._panelCount = 0;
            long start = JANOS.uptimeMillis();
            long[] addresses = JANOS.getExternalDeviceList();
            for (i = 0; i < addresses.length; ++i) {
                if ((addresses[i] & 0xFFL) != 250L) continue;
                ++this._panelCount;
            }
            this._panels = new long[this._panelCount];
            this._panelCount = 0;
            for (i = 0; i < addresses.length; ++i) {
                if ((addresses[i] & 0xFFL) != 250L) continue;
                this._panels[this._panelCount++] = addresses[i];
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
        }
        return this;
    }

    private ControlPanel() {
        this.enumeratePanels();
    }

    public String getHexAddress(int index) {
        if (index >= this._panelCount || this._panels[index] == 0L) {
            throw new NullPointerException("Panel does not exist at " + index);
        }
        return Long.toHexString(this._panels[index]);
    }

    public void addListener(ControlPanelListener listener) {
        System.out.println("ControlPanel.addListener(): " + listener);
        if (!this._listeners.contains(listener)) {
            this._listeners.add(listener);
            System.out.println(String.format("%d control panel listeners", this._listeners.size()));
        }
    }

    public void removeListener(ControlPanelListener listener) {
        System.out.println("ControlPanel.removeListener(): " + listener);
        for (ControlPanelListener o : this._listeners) {
            System.out.println("o = " + o);
        }
        this._listeners.remove(listener);
        System.out.println(String.format("%d control panel listeners", this._listeners.size()));
    }

    public void monitorSwitches(int rate) {
        this._monitorRate = rate;
        this.monitorSwitches();
    }

    public void monitorSwitches() {
        if (0 < this._panelCount && this._thd == null) {
            this._thd = new Thread((Runnable)this, this.getClass().getName() + ":" + this._monitorRate);
            this._thd.setDaemon(true);
            this._thd.start();
        }
    }

    public int getLeds() {
        return this._leds;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        try {
            int pendingTallyMask = 0;
            int mask = 0;
            byte[] readBlock = null;
            long nextPoll = JANOS.uptimeMillis() + 10000L;
            boolean pollPanel = false;
            while (true) {
                Object object;
                pollPanel = false;
                if (JANOS.uptimeMillis() > nextPoll) {
                    pollPanel = true;
                } else {
                    long[] alarmingDevices = null;
                    object = this._oneWireLock;
                    synchronized (object) {
                        alarmingDevices = JANOS.getAlarmingDeviceList();
                    }
                    if (alarmingDevices != null && alarmingDevices.length != 0) {
                        pollPanel = true;
                    }
                }
                if (pollPanel) {
                    System.out.println(String.format("%lld, poll panels", System.currentTimeMillis()));
                    nextPoll = JANOS.uptimeMillis() + 10000L;
                    for (int index = 0; index < this._panelCount; ++index) {
                        try {
                            object = this._oneWireLock;
                            synchronized (object) {
                                readBlock = JANOS.readDeviceBlock((long)this._panels[index]);
                                if (readBlock != null && readBlock.length == 4) {
                                    int switches = ArrayUtils.getShort((byte[])readBlock, (int)0);
                                    this._leds = ArrayUtils.getShort((byte[])readBlock, (int)2);
                                    if (this._checkLeds && this._leds != this._ledsMask) {
                                        int differingMask = this._leds ^ this._ledsMask;
                                        if (differingMask == this._ignoreMask) {
                                            // empty if block
                                        }
                                        if (this._onMask != 0) {
                                            this.setLEDs(this._onMask, this._onMask);
                                        }
                                        if (this._slowFlashMask != 0) {
                                            this.flashLEDs(this._slowFlashMask, 1, 0);
                                        }
                                        if (this._medFlashMask != 0) {
                                            this.flashLEDs(this._medFlashMask, 2, 0);
                                        }
                                        if (this._fastFlashMask != 0) {
                                            this.flashLEDs(this._fastFlashMask, 3, 0);
                                        }
                                    }
                                    if (this._ignoreMask != 0 & (this._ignoreMask ^ this._leds) != 0) {
                                        this._ignoreMask &= this._leds;
                                    }
                                    int channelMask = switches;
                                    if (switches != 0 || pendingTallyMask != 0) {
                                        mask = 1;
                                        for (int i = 0; i < 12; ++i) {
                                            if ((channelMask & 1) == 1) {
                                                int n = i;
                                                this._switchPresses[n] = this._switchPresses[n] + 1;
                                                pendingTallyMask |= 1 << i;
                                            } else if (this._switchPresses[i] > 0) {
                                                int listenerCount = this._listeners.size();
                                                for (int n = 0; n < listenerCount; ++n) {
                                                    ControlPanelListener fpl = this._listeners.get(n);
                                                    fpl.switchPressed(this, i + 1 + index * 12, this._switchPresses[i]);
                                                    pendingTallyMask &= ~mask;
                                                }
                                                this._switchPresses[i] = 0;
                                            }
                                            channelMask >>= 1;
                                            mask <<= 1;
                                        }
                                    }
                                    if (switches != 0) {
                                        int listenerCount = this._listeners.size();
                                        for (int i = 0; i < listenerCount; ++i) {
                                            ControlPanelListener fpl = this._listeners.get(i);
                                            fpl.switchesPressed(this, switches << index * 12);
                                        }
                                        this.acknowledgeSwitches(index, switches);
                                    }
                                    if (switches != 0 || pendingTallyMask != 0) {
                                        --index;
                                    }
                                }
                                continue;
                            }
                        }
                        catch (Exception ex) {
                            AppLog.error("Error reading User Control Panel", ex);
                        }
                    }
                }
                try {
                    Thread.sleep(this._monitorRate);
                }
                catch (InterruptedException ex) {
                    AppLog.error(null, ex);
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error reading User Control Panel", ex);
            AppLog.info("Done monitoring control panel");
            return;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void acknowledgeSwitches(int index, int channelMask) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            Object object = this._oneWireLock;
            synchronized (object) {
                ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                ArrayUtils.setShort((byte[])this._writeBlock, (int)6, (short)((short)channelMask));
                JANOS.writeDeviceBlock((long)this._panels[index], (byte[])this._writeBlock);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error acknowledging switches", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void resetPanels() throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            for (int index = 0; index < this._panelCount; ++index) {
                Object object = this._oneWireLock;
                synchronized (object) {
                    ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                    this._writeBlock[10] = 1;
                    JANOS.writeDeviceBlock((long)this._panels[index], (byte[])this._writeBlock);
                    continue;
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error resetting panels", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLedBrightness(byte brightness) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            for (int index = 0; index < this._panelCount; ++index) {
                Object object = this._oneWireLock;
                synchronized (object) {
                    ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                    this._writeBlock[10] = 2;
                    this._writeBlock[11] = brightness;
                    JANOS.writeDeviceBlock((long)this._panels[0], (byte[])this._writeBlock);
                    continue;
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error setting LED brightness", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setVolume(byte volume) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            for (int index = 0; index < this._panelCount; ++index) {
                Object object = this._oneWireLock;
                synchronized (object) {
                    ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                    this._writeBlock[10] = 4;
                    this._writeBlock[11] = volume;
                    JANOS.writeDeviceBlock((long)this._panels[0], (byte[])this._writeBlock);
                    continue;
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error setting volume", ex);
            throw ex;
        }
    }

    public void setLED(int channel, boolean state) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            if (channel < 1 || channel > (this._panelCount + 1) * 12) {
                throw new IllegalArgumentException("Invalid Channel");
            }
            this.setLEDs(1 << channel - 1, state ? 1 << channel - 1 : 0);
        }
        catch (Exception ex) {
            AppLog.error("Error commanding the control panel LED", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void setLEDs(int channelMask, int stateMask) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            for (int index = 0; index < this._panelCount; ++index) {
                int $channelMask = channelMask >> index * 12 & 0xFFF;
                if ($channelMask == 0) continue;
                int $stateMask = stateMask >> index * 12 & 0xFFF;
                Object object = this._oneWireLock;
                synchronized (object) {
                    ArrayUtils.setShort((byte[])this._writeBlock, (int)0, (short)((short)$channelMask));
                    ArrayUtils.setShort((byte[])this._writeBlock, (int)2, (short)((short)$stateMask));
                    ArrayUtils.arrayFill((byte[])this._writeBlock, (int)4, (int)20, (byte)0);
                    this._checkLeds = false;
                    JANOS.writeDeviceBlock((long)this._panels[index], (byte[])this._writeBlock);
                    this._ledsMask &= ~$channelMask;
                    this._ledsMask |= $stateMask & $channelMask;
                    this._onMask &= ~$channelMask;
                    this._onMask |= $stateMask & $channelMask;
                    this._checkLeds = true;
                    continue;
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error commanding the Control Panel LEDs", ex);
            throw ex;
        }
    }

    public void flashLED(int channel, int flashRate, int flashCount) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            if (channel < 1 || channel > (this._panelCount + 1) * 12) {
                throw new IllegalArgumentException("Invalid Channel");
            }
            this.flashLEDs(1 << channel - 1, flashRate, flashCount);
        }
        catch (Exception ex) {
            AppLog.error("Error flashing the Control Panel LED", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void flashLEDs(int channelMask, int flashRate, int flashCount) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            for (int index = 0; index < this._panelCount; ++index) {
                int $channelMask = channelMask >> index * 12 & 0xFFF;
                if ($channelMask == 0) continue;
                if (flashRate < -1 || flashRate > 3) {
                    throw new IllegalArgumentException("Invalid Flash Rate");
                }
                Object object = this._oneWireLock;
                synchronized (object) {
                    ArrayUtils.setShort((byte[])this._writeBlock, (int)0, (short)((short)$channelMask));
                    if (flashRate == -1) {
                        ArrayUtils.setShort((byte[])this._writeBlock, (int)2, (short)0);
                    } else {
                        ArrayUtils.setShort((byte[])this._writeBlock, (int)2, (short)((short)$channelMask));
                    }
                    this._writeBlock[4] = (byte)flashRate;
                    this._writeBlock[5] = (byte)flashCount;
                    ArrayUtils.arrayFill((byte[])this._writeBlock, (int)6, (int)20, (byte)0);
                    this._checkLeds = false;
                    JANOS.writeDeviceBlock((long)this._panels[index], (byte[])this._writeBlock);
                    if (flashRate >= 0 & flashCount == 0) {
                        this._ledsMask |= $channelMask;
                        switch (flashRate) {
                            case 0: {
                                this._onMask |= $channelMask;
                                break;
                            }
                            case 1: {
                                this._slowFlashMask |= $channelMask;
                                break;
                            }
                            case 2: {
                                this._medFlashMask |= $channelMask;
                                break;
                            }
                            case 3: {
                                this._fastFlashMask |= $channelMask;
                            }
                        }
                    } else if (flashRate >= 0 & flashCount != 0) {
                        this._ignoreMask |= $channelMask;
                    } else {
                        this._ledsMask &= ~$channelMask;
                        this._onMask &= ~$channelMask;
                        this._slowFlashMask &= ~$channelMask;
                        this._medFlashMask &= ~$channelMask;
                        this._fastFlashMask &= ~$channelMask;
                    }
                    this._checkLeds = true;
                    continue;
                }
            }
        }
        catch (Exception ex) {
            AppLog.error("Error flashing the Control Panel LEDs", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void playSound(byte soundId) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            Object object = this._oneWireLock;
            synchronized (object) {
                ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)10, (byte)0);
                this._writeBlock[10] = 3;
                this._writeBlock[11] = soundId;
                JANOS.writeDeviceBlock((long)this._panels[0], (byte[])this._writeBlock);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error playing control panel sound", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void soundAlarm(byte toneFrequency, byte toneCount, short toneLength, short period, short duration, byte volume) throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            Object object = this._oneWireLock;
            synchronized (object) {
                ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                this._writeBlock[10] = 5;
                this._writeBlock[11] = volume;
                this._writeBlock[12] = toneFrequency;
                this._writeBlock[13] = toneCount;
                ArrayUtils.setShort((byte[])this._writeBlock, (int)14, (short)toneLength);
                ArrayUtils.setShort((byte[])this._writeBlock, (int)16, (short)period);
                ArrayUtils.setShort((byte[])this._writeBlock, (int)18, (short)duration);
                JANOS.writeDeviceBlock((long)this._panels[0], (byte[])this._writeBlock);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error playing control panel sound", ex);
            throw ex;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void silenceAlarm() throws IOException, Exception {
        if (this._panelCount == 0) {
            throw new RuntimeException("There are no Control Panels Connected");
        }
        try {
            Object object = this._oneWireLock;
            synchronized (object) {
                ArrayUtils.arrayFill((byte[])this._writeBlock, (int)0, (int)20, (byte)0);
                this._writeBlock[10] = 6;
                JANOS.writeDeviceBlock((long)this._panels[0], (byte[])this._writeBlock);
            }
        }
        catch (Exception ex) {
            AppLog.error("Error playing control panel sound", ex);
            throw ex;
        }
    }
}

