/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.devices;

import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.devices.SNMPDevice;
import com.integ.tasker.devices.projectors.ProjectorFactory;
import com.integ.tasker.devices.soundprocessors.SoundProcessorFactory;
import java.util.Json;

public class DeviceFactory {
    public static DeviceProfile getDevice(Json json) throws Throwable {
        String typeString;
        switch (typeString = json.getString("Type")) {
            case "EthernetDevice": {
                return new EthernetDevice(json);
            }
            case "SNMPDevice": {
                return new SNMPDevice(json);
            }
            case "ProjectorDevice": {
                return ProjectorFactory.getDevice(json);
            }
            case "SoundProcessorDevice": {
                return SoundProcessorFactory.getDevice(json);
            }
        }
        throw new Exception(String.format("Unknown Device Type: %s in %s", typeString, json.toString()));
    }
}

