/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.http.server;

import com.integpg.janoslib.http.HttpConnection;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.OutputStream;
import java.util.Hashtable;

public class HttpRequest {
    private final HttpConnection _httpConnection;
    private String _request;
    private String _requestType;
    private String _requestedURI;
    private String _requestedResource;
    private String _httpVersion;
    private String _queryString = "<null>";
    private final Hashtable<String, String> _headers = new Hashtable();
    private Hashtable<String, String> _queryParams;

    public String getRequest() {
        return this._request;
    }

    public String getRequestType() {
        return this._requestType;
    }

    public String getRequestedURI() {
        return this._requestedURI;
    }

    public String getRequestedResource() {
        return this._requestedResource;
    }

    public String getHttpVersion() {
        return this._httpVersion;
    }

    public Hashtable<String, String> getQueryParams() {
        if (null == this._queryParams) {
            this._queryParams = new Hashtable();
            int lastPos = 0;
            if (!"".equals(this._queryString)) {
                int queryLength = this._queryString.length();
                while (queryLength > lastPos) {
                    int pos = this._queryString.indexOf("=", lastPos);
                    if (-1 == pos) {
                        pos = queryLength;
                    }
                    String key = this._queryString.substring(lastPos, pos);
                    lastPos = pos + 1;
                    String value = "";
                    if (pos < queryLength) {
                        pos = this._queryString.indexOf("&", lastPos);
                        if (-1 == pos) {
                            pos = queryLength;
                        }
                        value = this._queryString.substring(lastPos, pos);
                        lastPos = pos + 1;
                    }
                    value = this.urlDecode(value);
                    this._queryParams.put(key, value);
                }
            }
        }
        return this._queryParams;
    }

    public Hashtable<String, String> getHeaderCollection() {
        return this._headers;
    }

    public HttpRequest(HttpConnection httpConnection) {
        this._httpConnection = httpConnection;
    }

    void processRequest() {
        BufferedReader br = null;
        try {
            InputStreamReader inputStreamReader = new InputStreamReader(this._httpConnection.getInputStream());
            br = new BufferedReader(inputStreamReader);
            this._request = br.readLine();
            if (!"".equals(this._request)) {
                String line;
                int lastPos = 0;
                int spacePos = this._request.indexOf(" ");
                this._requestType = this._request.substring(0, spacePos);
                lastPos = spacePos + 1;
                spacePos = this._request.indexOf(" ", lastPos);
                this._requestedURI = this._request.substring(lastPos, spacePos);
                this._httpVersion = this._request.substring(spacePos + 1);
                int questionMarkPos = this._requestedURI.indexOf("?");
                if (-1 == questionMarkPos) {
                    questionMarkPos = this._requestedURI.length();
                }
                this._requestedResource = this._requestedURI.substring(0, questionMarkPos);
                if (questionMarkPos != this._requestedURI.length()) {
                    this._queryString = this._requestedURI.substring(questionMarkPos + 1);
                }
                System.out.println(String.format("%lld start processing %s request", System.currentTimeMillis(), this._requestedResource));
                while (!"".equals(line = br.readLine())) {
                    int colonPos = line.indexOf(":");
                    this._headers.put(line.substring(0, colonPos), line.substring(colonPos + 1));
                }
            }
        }
        catch (IOException ex) {
            ex.printStackTrace();
            try {
                if (null != br) {
                    br.close();
                }
            }
            catch (IOException ex2) {
                ex2.printStackTrace();
            }
        }
    }

    public void close() throws IOException {
        this._httpConnection.close();
    }

    public OutputStream getOutputStream() throws IOException {
        return this._httpConnection.getOutputStream();
    }

    private String urlDecode(String s) {
        boolean changed = false;
        int numChars = s.length();
        StringBuilder sb = new StringBuilder(numChars > 500 ? numChars / 2 : numChars);
        int i = 0;
        byte[] bytes = null;
        block6: while (i < numChars) {
            char c = s.charAt(i);
            switch (c) {
                case '+': {
                    sb.append(' ');
                    ++i;
                    changed = true;
                    continue block6;
                }
                case '%': {
                    try {
                        if (bytes == null) {
                            bytes = new byte[(numChars - i) / 3];
                        }
                        int pos = 0;
                        while (i + 2 < numChars && c == '%') {
                            int v = Integer.parseInt(s.substring(i + 1, i + 3), 16);
                            if (v < 0) {
                                throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - negative value");
                            }
                            bytes[pos++] = (byte)v;
                            if ((i += 3) >= numChars) continue;
                            c = s.charAt(i);
                        }
                        if (i < numChars && c == '%') {
                            throw new IllegalArgumentException("URLDecoder: Incomplete trailing escape (%) pattern");
                        }
                        sb.append(new String(bytes, 0, pos));
                    }
                    catch (NumberFormatException e) {
                        throw new IllegalArgumentException("URLDecoder: Illegal hex characters in escape (%) pattern - " + e.getMessage());
                    }
                    changed = true;
                    continue block6;
                }
            }
            sb.append(c);
            ++i;
        }
        return changed ? sb.toString() : s;
    }
}

