/* global bootbox, Tasker */

TaskerApp.controller('ScheduleController', function ($scope, $compile, ScheduleService, TaskService) {
    var _this = this;



    _this.getTasks = function () {
        return TaskService.TaskList;
    };



    _this.getDescription = function (scheduleJson) {
        try {
            switch (scheduleJson.ScheduleType) {
                case 'Schedule':
                    var result = '';

                    var timeOptions = scheduleJson.TimeOptions;
                    if (timeOptions) {

                        var dateOptions = scheduleJson.DateOptions;
                        var dateString = '';
                        if (dateOptions) {
                            switch (dateOptions.DateRecurranceType) {
                                case 'Daily':
                                    var dateRecurranceInterval = dateOptions.DateRecurranceInterval;
                                    if (1 == dateRecurranceInterval) dateString = 'Daily';
                                    else if (2 == dateRecurranceInterval) dateString = 'Every Other Day';
                                    else if (0 == dateRecurranceInterval % 7) {
                                        var weeks = dateRecurranceInterval / 7;
                                        if (1 == weeks) dateString = 'Every week';
                                        else dateString = 'Every ' + weeks + ' weeks';
                                    }
                                    else dateString = 'Every ' + dateRecurranceInterval + ' days';
                                    break;

                                case 'Weekly':
                                    var daysOfWeek = ['Sunday', 'Monday', 'Tuesday', 'Wednesday', 'Thursday', 'Friday', 'Saturday'];
                                    for (var i = 0; i < daysOfWeek.length; i++) {
                                        var day = daysOfWeek[i];
                                        var dayEnabled = dateOptions.Days[day];
                                        if (dayEnabled) {
                                            if (0 < dateString.length) dateString += ', ';
                                            dateString += day;
                                        }
                                    }
                                    dateString = 'on ' + dateString;
                                    break;

                                case 'None':
                                    dateString = 'on ' + dateOptions.StartDate;
                                    break;

                            }
                        }

                        var start = timeOptions.Start;
                        startTime = start.Hour.leftPad(2) + ':' + start.Minute.leftPad(2);
                        if (0 == start.Hour && 0 == start.Minute) startTime = 'Midnight';
                        if (12 == start.Hour && 0 == start.Minute) startTime = 'Noon';

                        if (0 < timeOptions.RepeatInterval) {
                            var end = timeOptions.End;
                            var endTime = '';
                            if (end) {
                                endTime = end.Hour.leftPad(2) + ':' + end.Minute.leftPad(2);
                                if (0 == end.Hour && 0 == end.Minute) endTime = 'Midnight';
                                if (12 == end.Hour && 0 == end.Minute) endTime = 'Noon';
                            }

                            var repeatString = timeOptions.RepeatInterval + ' ' + timeOptions.RepeatIntervalUnits;
                            if (1 == timeOptions.RepeatInterval) repeatString =
                                timeOptions.RepeatIntervalUnits.substring(0, timeOptions.RepeatIntervalUnits.length - 1);
                            result += 'Repeat every ' + repeatString +
                                ' starting at ' + startTime + ' until ' + endTime + ' ' + dateString;
                        } else {
                            result += 'Execute  at ' + startTime + ' ' + dateString;
                        }
                    }

                    return result;

                case 'Sunrise':
                case 'Sunset':
                    return 'Task will execute at ' + scheduleJson.ScheduleType;

                case 'On Boot':
                    return 'Task will execute on boot';

            }
        } catch (err) {
            return 'Invalid Format: Most likely because of development';
        }
    }



    _this.areSchedulesLoaded = function () {
        return ScheduleService.SchedulesLoaded;
    };



    _this.getSchedules = function () {
        return ScheduleService.ScheduleList;
    };



    _this.selectSchedule = function (schedule) {
        ScheduleService.SelectedSchedule = schedule;
    };


    _this.getSelectedSchedule = function () {
        return ScheduleService.SelectedSchedule;
    };



    _this.SelectedSchedule = null;
    _this.addSchedule = function () {
        bootbox.prompt({
            className: 'bb-success',
            title: "What is the name of the new Schedule?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success'
                }
            },
            callback: function (result) {
                if (result) {

                    if (undefined == ScheduleService.ScheduleList) ScheduleService.ScheduleList = [];
                    var schedule = new ScheduleObject(result);
                    // schedule.Action = new ControlFunction();
                    ScheduleService.ScheduleList.push(schedule);

                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));
        });
    };



    _this.editScheduleName = function (schedule) {
        bootbox.prompt({
            title: "Edit the name of the Schedule?",
            // message: '<p class="alert alert-warning"><b>Careful!</b>  Changing the name of the' +
            //     ' Schedule can have negative consequences if it it referenced elsewhere in Tasker. ' +
            //     ' Please make sure to change the name used in the references.</p>',
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Update',
                    className: 'btn-success'
                }
            },
            value: schedule.Name,
            callback: function (result) {
                if (result) {
                    schedule.Name = result;
                    $scope.$apply();
                }
            }
        }).init(function () {
            validate_alphanumeric($(".bootbox-input"));
            submit_on_enter($(".bootbox-input"));

            $(".modal-header").css("background-color", "#5cb85c");
            $(".modal-header").css("color", "#fff");
        });
    };



    // _this.editScheduleName = function (schedule) {
    //     bootbox.prompt({
    //         title: "Edit the name of the Schedule?",
    //         buttons: {
    //             cancel: {
    //                 label: 'Cancel',
    //                 className: 'btn-default'
    //             },
    //             confirm: {
    //                 label: 'Update',
    //                 className: 'btn-success'
    //             }
    //         },
    //         value: schedule.Name,
    //         callback: function (result) {
    //             if (result) {
    //                 schedule.Name = result;
    //                 $scope.$apply();
    //             }
    //         }
    //     }).init(function () {
    //         this.value = this.value.replace(/ /g, '_');
    //         this.value = this.value.replace(/^[0-9]+|[^a-zA-Z0-9_]/g, '');

    //         if (e.which == 13) {
    //             e.preventDefault();
    //             $(".bootbox .btn-submit").click();
    //         }

    //         $(".modal-header").css("background-color", "#5cb85c");
    //         $(".modal-header").css("color", "#fff");
    //     });
    // };



    _this.removeSchedule = function (schedule) {
        bootbox.confirm({
            title: "Are you sure?",
            message: "Are you sure you wish to remove the '" + schedule.Name + "' schedule?",
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Remove',
                    className: 'btn-warning'
                }
            },
            callback: function (result) {
                if (result) {

                    var index = ScheduleService.ScheduleList.indexOf(schedule);
                    if (-1 != index) {
                        ScheduleService.ScheduleList.splice(index, 1);
                    }

                    $scope.$apply();
                }
            }
        }).init(function () {
            $(".modal-header").css("background-color", "#f0ad4c");
            $(".modal-header").css("color", "#fff");
        });
    };



    _this.addRuleToSchedule = function (schedule) {
        _this.SelectedRule = { ScheduleType: "Schedule" };

        var template = '<div ng-include="\'schedules/schedule.html\'"></div>';
        var linkFn = $compile(template);
        var html = linkFn($scope);

        bootbox.dialog({
            className: 'bb-primary',
            title: "Schedule Rule",
            message: html,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'Add',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var form = $("#rule-form");
                            form.validate({ errorPlacement: function (error, element) { } });

                            if (form.valid()) {
                                if (undefined == schedule.Params) schedule.Params = {};
                                if (undefined == schedule.Params.Rules) schedule.Params.Rules = [];
                                schedule.Params.Rules.push(_this.SelectedRule);

                                $scope.$apply();
                            } else return false;
                        }
                    }
                }
            }
        });

    };



    _this.editRule = function (rule) {
        if (rule) _this.SelectedRule = angular.copy(rule);
        else _this.SelectedRule = {};

        var template = '<div ng-include="\'schedules/schedule.html\'"></div>';
        var linkFn = $compile(template);
        var html = linkFn($scope);

        bootbox.dialog({
            className: 'bb-primary',
            title: "Schedule Rule",
            message: html,
            buttons: {
                cancel: {
                    label: 'Cancel',
                    className: 'btn-default'
                },
                confirm: {
                    label: 'OK',
                    className: 'btn-success',
                    callback: function (result) {
                        if (result) {
                            var form = $("#rule-form");
                            form.validate({ errorPlacement: function (error, element) { } });

                            if (form.valid()) {
                                rule.ScheduleType = _this.SelectedRule.ScheduleType;
                                rule.TimeOptions = angular.copy(_this.SelectedRule.TimeOptions);
                                rule.DateOptions = _this.SelectedRule.DateOptions;

                                $scope.$apply();
                            } else return false;
                        }
                    }
                }
            }
        });
    };



    _this.removeRuleFromSchedule = function (rule, schedule) {
        var index = schedule.Params.Rules.indexOf(rule);
        if (0 <= index) {
            schedule.Params.Rules.splice(index, 1);
            $scope.$apply();
        }
    };
});



/*
   SERVICE
*/
TaskerApp.service('ScheduleService', function ($rootScope, TaskService) {
    var _this = this;
    _this.ScheduleList = [];
    _this.SelectedSchedule = null;
    _this.SchedulesLoaded = false;



    _this.load = function (scheduleListJson) {
        if (undefined == scheduleListJson) scheduleListJson = [];

        try {
            parseScheduleList(scheduleListJson);
        } catch (err) {
            console.error(err);
        }

        $rootScope.$apply();

        _this.SelectedSchedule = null;
        _this.SchedulesLoaded = true;

        return _this.ScheduleList;
    };



    function parseScheduleList(scheduleArray) {
        // empty our array of schedules
        _this.ScheduleList = [];

        scheduleArray.forEach(function (scheduleJson) {
            var schedule = new ScheduleObject(scheduleJson.Name, scheduleJson.Params);
            schedule.GUID = scheduleJson.GUID;
            _this.ScheduleList.push(schedule);
        });
    };



    _this.validate = function () {
        var form = $("#schedule-form");
        form.validate({ errorPlacement: function (error, element) { } });
        var valid = form.valid();
        return valid;
    };
});