/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.signals;

import com.integ.tasker.WorkspaceConfigurationFile;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.signals.SignalProfilesCollection;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.Json;

public class SignalConfiguration {
    private static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_signals.log").setLogType(LogTypes.HalfBak));
    private final WorkspaceConfigurationFile _workspaceConfigurationFile;
    private final SignalProfilesCollection _signalProfileCollection = new SignalProfilesCollection();

    public SignalConfiguration(WorkspaceConfigurationFile workspaceConfigurationFile) {
        this._workspaceConfigurationFile = workspaceConfigurationFile;
    }

    public SignalProfilesCollection getSignalProfilesCollection() {
        return this._signalProfileCollection;
    }

    public void loadConfiguration(Json[] signalListJsonArray) throws Throwable {
        if (null == signalListJsonArray || 0 == signalListJsonArray.length) {
            return;
        }
        for (Json signalJson : signalListJsonArray) {
            LOG.info("signalJson: " + signalJson);
        }
        this._signalProfileCollection.clear();
        for (Json signalJson : signalListJsonArray) {
            SignalProfile signalProfile = new SignalProfile(signalJson);
            this._signalProfileCollection.put(signalProfile);
        }
    }
}

