/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.relayoutputs;

import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integpg.system.JANOS;
import java.io.IOException;
import java.util.Json;

public class PulseRelayMethod
extends Action {
    public PulseRelayMethod(Task parentTask, Json json) {
        super(parentTask, json);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            int channel = this.getIntParam("Channel", taskRuntime);
            String stateString = this.getStringParam("State", taskRuntime);
            if (null == stateString) {
                stateString = "HIGH";
            }
            double duration = this.getDoubleParam("Duration", taskRuntime);
            int durationMillis = (int)(duration * 1000.0);
            if ("HIGH".equalsIgnoreCase(stateString)) {
                JANOS.setOutputPulsed((int)(1 << channel - 1), (int)(1 << channel - 1), (int)durationMillis);
            } else {
                JANOS.setOutputPulsed((int)0, (int)(1 << channel - 1), (int)durationMillis);
            }
        }
        catch (IOException ex) {
            throw new IOException("Error pulsing channel").initCause(ex);
        }
    }
}

