/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.triggers;

import com.integ.janoslib.iolog.IoChannelEvent;
import com.integ.janoslib.iolog.IoChannelLogListener;
import com.integ.tasker.TaskerMain;
import com.integ.tasker.signals.SignalProfile;
import com.integ.tasker.triggers.DeviceSignalDictionary;
import com.integ.tasker.triggers.Reset;
import com.integpg.janoslib.externalio.ExternalModule;
import java.util.Json;

class DiscreteReset
extends Reset
implements IoChannelLogListener {
    private final SignalProfile _resetSignalProfile;
    private final ExternalModule _resetDevice;
    private String _resetState;
    private boolean _isReset;

    public DiscreteReset(SignalProfile resetSignalProfile, Json resetJson) {
        this._resetSignalProfile = resetSignalProfile;
        System.out.println("resetJson: " + resetJson);
        this._resetDevice = DeviceSignalDictionary.get(this._resetSignalProfile.DeviceType);
        System.out.println("_resetDevice: " + this._resetDevice);
        this._resetState = resetJson.getString("State");
        System.out.println("_resetState: " + this._resetState);
        if ("din".equalsIgnoreCase(this._resetSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_INPUT_MONITOR.addDigitalInputListener(this);
        }
        if ("rout".equalsIgnoreCase(this._resetSignalProfile.DeviceType)) {
            TaskerMain.DIGITAL_OUTPUT_MONITOR.addDigitalOutputListener(this);
        }
    }

    @Override
    public void makeReset() {
        if ("high".equalsIgnoreCase(this._resetState)) {
            this._resetState = "low";
        } else if ("low".equalsIgnoreCase(this._resetState)) {
            this._resetState = "high";
        }
    }

    @Override
    public boolean checkForReset() throws Throwable {
        return this._isReset;
    }

    public String toString() {
        return " will reset when " + this._resetSignalProfile.DeviceType + this._resetSignalProfile.Channel + " is " + this._resetState;
    }

    @Override
    public void onIoChannelEvent(IoChannelEvent ioEvent) {
        System.out.println("digitalInput.Channel: " + ioEvent.Channel + ", _resetSignalProfile.Channel: " + this._resetSignalProfile.Channel);
        if (ioEvent.Channel == this._resetSignalProfile.Channel) {
            System.out.println("_resetState: " + this._resetState + ", digitalInput.State: " + ioEvent.State);
            if ("high".equalsIgnoreCase(this._resetState)) {
                this._isReset = ioEvent.State;
            } else if ("low".equalsIgnoreCase(this._resetState)) {
                this._isReset = !ioEvent.State;
            }
        }
    }
}

