/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.messagepump;

import com.integpg.janoslib.logging.Logger;
import com.integpg.janoslib.messagepump.MessagePumpAppMessageListener;
import com.integpg.janoslib.messagepump.MessagePumpEngine;
import com.integpg.janoslib.messagepump.MessagePumpListener;
import com.integpg.system.SystemMsg;
import java.util.Hashtable;
import java.util.Json;

public class MessagePumpAppHandler
implements MessagePumpListener {
    private final Hashtable<String, MessagePumpAppMessageListener> _appMessageListeners = new Hashtable();
    private final int _type;
    private static Logger LOG = Logger.getLogger();
    private SystemMsg _systemMsg;
    private Json _receivedJson;
    private String _messageString;

    public MessagePumpAppHandler(int type) {
        this._type = type;
    }

    public static void setLog(Logger log) {
        LOG = log;
    }

    public static Logger getLog() {
        return LOG;
    }

    public MessagePumpAppHandler addCommandListener(String command, MessagePumpAppMessageListener listener) {
        this._appMessageListeners.put(command, listener);
        LOG.info(String.format("   added handler for %s:%d = %s", command, this._type, listener.getClass().getName()));
        return this;
    }

    @Override
    public void messageReceived(SystemMsg systemMsg) {
        if (this._type == systemMsg.type) {
            this._systemMsg = systemMsg;
            long start = System.currentTimeMillis();
            this.processMessage();
            long l = System.currentTimeMillis() - start;
        }
    }

    private void processMessage() {
        String contentJsonString = new String(this._systemMsg.msg);
        this._receivedJson = new Json(contentJsonString);
        this._messageString = this._receivedJson.getString("Message");
        if (null != LOG) {
            String s = String.format("App Message: %s", this._messageString);
            LOG.info(s);
        }
        if (this._appMessageListeners.containsKey(this._messageString)) {
            MessagePumpAppMessageListener listener = this._appMessageListeners.get(this._messageString);
            LOG.info(String.format("   %s processing %s", listener.getClass().getName(), this._messageString));
            if (null != listener) {
                listener.applicationMessageReceived(this._receivedJson);
            }
        } else {
            LOG.info(String.format("  %s does not contain a listeners for %s", this.getClass().getName(), this._messageString));
        }
    }

    private void sendReponse(Json json) {
        SystemMsg responseMsg = new SystemMsg();
        responseMsg.type = this._systemMsg.type;
        responseMsg.msg = json.toString().getBytes();
        MessagePumpEngine.postMessage(responseMsg);
    }
}

