/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.janoslib.iolog;

import com.integpg.janoslib.iolog.DigitalInputChannelEvent;
import com.integpg.janoslib.iolog.IoChannelLogListener;
import com.integpg.janoslib.iolog.IoLogMonitor;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.IoEvent;
import com.integpg.system.JANOS;

public class DigitalInputsIoLogMonitor
extends IoLogMonitor {
    protected static IoEvent _lastInputEvent;

    public static IoEvent getLastInputEvent() {
        return _lastInputEvent;
    }

    @Override
    public void alertIoChannelListeners(IoEvent ioEvent) {
        _lastInputEvent = ioEvent;
        if (0 != this._ioChannelLogEventListeners.size()) {
            for (int chan = 0; chan < UnitConfig.getInputCount(); ++chan) {
                if (1 != (ioEvent.mask >> chan & 1)) continue;
                int state = ioEvent.states >> chan & 1;
                System.out.println(String.format("@%s channel %d is now %s", QUICK_DATE_FORMAT.format(ioEvent.timestamp), chan + 1, 1 == state ? "HIGH" : "LOW"));
                DigitalInputChannelEvent digitalInputEvent = new DigitalInputChannelEvent();
                digitalInputEvent.Channel = chan + 1;
                digitalInputEvent.TransitionTime = ioEvent.timestamp;
                digitalInputEvent.State = 1 == state;
                digitalInputEvent.Counter = JANOS.getInputCounter((int)chan);
                digitalInputEvent.UsageMeter = JANOS.getUsageMeter((int)chan);
                for (IoChannelLogListener ioChannelListener : this._ioChannelLogEventListeners) {
                    ioChannelListener.onIoChannelEvent(digitalInputEvent);
                }
            }
        }
    }

    @Override
    protected IoEvent[] getIoEvents() {
        return this._iolog.getInputEvents();
    }
}

