/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.tasks.actions.network;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.TextReplacer;
import com.integ.tasker.devices.DeviceCollection;
import com.integ.tasker.devices.DeviceProfile;
import com.integ.tasker.devices.EthernetDevice;
import com.integ.tasker.devices.SNMPDevice;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskRuntime;
import com.integ.tasker.tasks.actions.Action;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integpg.janoslib.io.AppLog;
import com.integpg.system.SystemMsg;
import java.util.Json;

public class SNMPSetMethod
extends Action {
    public SNMPSetMethod(Task parentTask, Json json) {
        super(parentTask, json);
        String deviceGuid = this._paramsJson.getString("DeviceGUID");
        DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
        if (null == device) {
            throw new RuntimeException("No device found for " + deviceGuid);
        }
        if (!(device instanceof EthernetDevice)) {
            throw new RuntimeException("Device found for " + deviceGuid + " is not an Ethernet Device");
        }
        String oid = this._paramsJson.getString("OID");
        String message = this._paramsJson.getString("Message");
        Json deviceActionJson = new Json();
        deviceActionJson.put("type", (Object)"SNMPSet");
        deviceActionJson.put("name", (Object)device.Name);
        deviceActionJson.put("oid", (Object)oid);
        deviceActionJson.put("message", (Object)message);
        this._parentTask.addDeviceActionJson(deviceActionJson);
    }

    @Override
    public void execute(TaskRuntime taskRuntime) throws Throwable {
        try {
            String deviceGuid = this._paramsJson.getString("DeviceGUID");
            String oid = this._paramsJson.getString("OID");
            String message = this._paramsJson.getString("Message");
            message = TextReplacer.replace(message, taskRuntime.Scope);
            String type = this._paramsJson.getString("Type");
            try {
                if (null == deviceGuid || "".equals(deviceGuid)) {
                    throw new RuntimeException("No device was selected for this SNMP Set");
                }
                DeviceProfile device = DeviceCollection.GLOBAL.getByDeviceGUID(deviceGuid);
                if (null == device) {
                    throw new RuntimeException("No device found for " + deviceGuid);
                }
                if (!(device instanceof SNMPDevice)) {
                    throw new RuntimeException("Device found for " + deviceGuid + " is not a SNMP Device");
                }
                SNMPDevice snmpDevice = (SNMPDevice)device;
                String host = snmpDevice.getIpAddress();
                int port = snmpDevice.getPort();
                try {
                    Json jsonMessage = new Json();
                    jsonMessage.put("host", (Object)host);
                    jsonMessage.put("port", port);
                    jsonMessage.put("oid", (Object)oid);
                    jsonMessage.put("value", (Object)message);
                    jsonMessage.put("type", (Object)type);
                    SystemMsg systemMsg = new SystemMsg();
                    systemMsg.type = 3002;
                    systemMsg.msg = jsonMessage.toString().getBytes();
                    MessagePumpEngine.postMessage(systemMsg);
                }
                catch (Exception ex) {
                    throw new RuntimeException(String.format("Error sending set %s for oid %s to %s:%d - %s", message, oid, host, port, ex.getMessage()));
                }
            }
            catch (Exception ex) {
                AppLog.warn(ex.getMessage());
                ErrorMessage errorMessage = new ErrorMessage(ex.getMessage());
                MessagePumpEngine.postMessage(errorMessage.build());
            }
        }
        catch (Exception ex) {
            throw new Exception("Error executing SNMP Set").initCause(ex);
        }
    }

    public String toString() {
        String oid = this._paramsJson.getString("OID");
        String message = this._paramsJson.getString("Message");
        return String.format("%s: %s", oid, message);
    }
}

