/*
 * Decompiled with CFR 0.152.
 */
package com.integ.scripting.objects;

import com.integ.scripting.ExpressionEngine;
import com.integ.scripting.exceptions.ScriptParserException;
import com.integ.scripting.exceptions.UnexpectedTokenException;
import com.integ.scripting.nodes.AbstractNode;
import com.integ.scripting.nodes.ValueNode;
import com.integ.scripting.objects.AbstractObjectCall;
import com.integ.tasker.tasks.Scope;
import com.integpg.janoslib.system.UnitConfig;
import com.integpg.system.JANOS;

public class RelayOutputObject
extends AbstractObjectCall {
    private int _channel;

    @Override
    public AbstractNode parse(ExpressionEngine parser) throws ScriptParserException {
        try {
            if (!parser.nextToken().checkType(91)) {
                throw new UnexpectedTokenException("[", parser.currentToken());
            }
            if (!parser.nextToken().checkType(3)) {
                throw new UnexpectedTokenException("NUMBER", parser.currentToken());
            }
            ValueNode valueNode = (ValueNode)parser.getObject();
            this._channel = (Integer)valueNode.Value;
            if (!parser.nextToken().checkType(93)) {
                throw new UnexpectedTokenException("[]", parser.currentToken());
            }
            if (!parser.nextToken().checkType(46)) {
                throw new UnexpectedTokenException(".", parser.currentToken());
            }
            if (!parser.nextToken().checkType(0)) {
                throw new UnexpectedTokenException("FIELD NAME", parser.currentToken());
            }
            this._fieldOrMethodName = parser.currentToken().content;
        }
        catch (Exception ex) {
            throw new ScriptParserException("unable to process relay output");
        }
        return this;
    }

    @Override
    public Object execute(Scope scope) {
        return RelayOutputObject.read(this._channel, this._fieldOrMethodName);
    }

    public static Object read(int channel, String fieldOrMethodName) {
        if ("state".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getOutputStates() >> channel - 1 & 1;
        }
        if ("usagemeter".equalsIgnoreCase(fieldOrMethodName)) {
            return JANOS.getUsageMeter((int)(UnitConfig.getInputCount() + channel - 1));
        }
        throw new RuntimeException(String.format("unknown field or method: %s", fieldOrMethodName));
    }
}

