/*
 * Decompiled with CFR 0.152.
 */
package com.integ.tasker.schedules;

import com.integ.janoslib.messagepump.MessagePumpEngine;
import com.integ.tasker.Unloadable;
import com.integ.tasker.schedules.ScheduleCollection;
import com.integ.tasker.schedules.rules.OnBootRule;
import com.integ.tasker.schedules.rules.ScheduleRuleBase;
import com.integ.tasker.schedules.rules.ScheduleRuleFactory;
import com.integ.tasker.tasks.Task;
import com.integ.tasker.tasks.TaskCollection;
import com.integ.tasker.tasks.TaskResult;
import com.integ.tasker.web.messages.ErrorMessage;
import com.integ.tasker.workspaces.WorkspaceFile;
import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.logger.FileLog;
import com.integpg.janoslib.logger.LogOptions;
import com.integpg.janoslib.logger.LogTypes;
import com.integpg.janoslib.logger.Logger;
import com.integpg.janoslib.system.Application;
import java.util.ArrayList;
import java.util.Json;

public class Schedule
implements Unloadable {
    public static final Logger LOG = FileLog.getLog(new LogOptions(Application.getAppName() + "_schedules.log").setLogType(LogTypes.HalfBak));
    private final Json _json;
    private final WorkspaceFile _parentWorkspaceFile;
    private Json _paramsJson;
    public String Name;
    public String GUID;
    public String TaskName;
    private ArrayList<ScheduleRuleBase> _scheduleRules = new ArrayList();
    private boolean _isUnloaded = false;

    public Schedule(Json json, WorkspaceFile parentWorkspaceFile) {
        this._json = json;
        this._parentWorkspaceFile = parentWorkspaceFile;
        try {
            LOG.info("loading Schedule from " + json);
            this.Name = json.getString("Name");
            this.GUID = json.getString("GUID");
            this._paramsJson = (Json)this._json.get("Params");
            boolean enabled = this._paramsJson.getBoolean("Enabled");
            if (!enabled) {
                LOG.info(String.format("%s (%s) is not enabled", this.Name, this.GUID));
                return;
            }
            this.TaskName = this._paramsJson.getString("TaskName");
            LOG.info(String.format("schedule %s (%s) will execute %s", this.Name, this.GUID, this.TaskName));
            this.loadRules();
            parentWorkspaceFile.addUnloadable(this);
        }
        catch (Throwable ex) {
            Throwable throwable = new Exception("unable to load " + this.Name).initCause(ex);
            LOG.error(throwable);
            ErrorMessage message = new ErrorMessage(throwable);
            MessagePumpEngine.postMessage(message.build());
        }
    }

    @Override
    public void unload() {
        this._isUnloaded = true;
        ScheduleCollection.remove(this);
    }

    private void loadRules() {
        Json[] rulesJsonArray = (Json[])this._paramsJson.get("Rules");
        if (null != rulesJsonArray) {
            for (Json ruleJson : rulesJsonArray) {
                ScheduleRuleBase scheduleBase = ScheduleRuleFactory.getRule(this, ruleJson);
                if (scheduleBase instanceof OnBootRule && this._parentWorkspaceFile.wasLoadedOnBoot()) {
                    this.execute();
                    continue;
                }
                this._scheduleRules.add(scheduleBase);
            }
        }
    }

    public ArrayList<ScheduleRuleBase> getScheduleRules() {
        return this._scheduleRules;
    }

    public void execute() {
        String description = String.format("%s execute %s", this.Name, this.TaskName);
        new Thread(new Runnable(){

            @Override
            public void run() {
                try {
                    Task task = TaskCollection.GLOBAL.getByTaskName(Schedule.this.TaskName);
                    if (null != task) {
                        TaskResult taskResult = task.execute(String.format("Schedule: %s", Schedule.this.Name));
                    }
                }
                catch (Throwable ex) {
                    AppLog.error(ex);
                    ErrorMessage message = new ErrorMessage(ex);
                    MessagePumpEngine.postMessage(message.build());
                }
            }
        }, description).start();
    }

    boolean isUnloaded() {
        return this._isUnloaded;
    }
}

