function parseNetworkAction(json) {
    var method = json.Method;

    switch (method) {
        case 'TcpSend':
            return new TcpSend();

        case 'TcpRecv':
            return new TcpRecv();

        case 'TcpClose':
            return new TcpClose();

        case 'SerialSend':
            return new SerialSend();

        case 'EmailSend':
            return new EmailEntry();

        case 'EmailProfileSend':
            return new EmailProfile();

        case 'SNMPTrap':
            return new SNMPTrap();

        case 'SNMPSet':
            return new SNMPSet();

        case 'HTTPGet':
            return new HTTPGet();

        case 'HTTPPost':
            return new HTTPPost();

        case 'MQTTPublish':
            return new MQTTPublish();

        case 'ProjectorSend':
            return new ProjectorSend();

        case 'SoundProcessorSend':
            return new SoundProcessorSend();

        default:
            throw new Error('Unknown Network Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class NetworkAction extends Action {
    constructor() {
        super();
        this.Type = 'Network';
        this.Method = 'void';
        this.Params = {};
    }
}



class TcpSend extends NetworkAction {
    constructor(message) {
        super();
        this.Method = 'TcpSend';
        this.Params.Message = message;
    }

    editTemplate() {
        var template = 'Tcp Send to ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data will be sent to" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' the following message' +
            ' <input name="tcpsend-message" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped characters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />';
        return template;
    }
}



class TcpRecv extends NetworkAction {
    constructor() {
        super();
        this.Method = 'TcpRecv';
    }

    editTemplate() {
        var template = 'Tcp Receive from ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data will be received from" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' ';
        return template;
    }
}



class TcpClose extends NetworkAction {
    constructor() {
        super();
        this.Method = 'TcpClose';
    }

    editTemplate() {
        var template = 'Tcp Close ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that will be closed" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' ';
        return template;
    }
}



class SerialSend extends NetworkAction {
    constructor(message) {
        super();
        this.Method = 'SerialSend';
        this.Params.Message = message;
    }

    editTemplate() {
        var template = 'Serial Send to ' +
            '<select name="tcpsend-device" class="form-control" ng-model="action.Params.SerialPort" ng-options="serial for serial in [\'AUX\', \'COM\']"' +
            '  data-toggle="tooltip" title="Select the Serial Port that will be used to send the following data" required>\r\n' +
            '   <option value=""></option></select>\r\n' +
            ' the following data' +
            ' <input name="tcpsend-message" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped characters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />';
        return template;
    }
}



class EmailEntry extends NetworkAction {
    constructor(toRecipient, subject, body) {
        super();
        this.Method = 'EmailSend';
        this.Params.ToRecipient = toRecipient;
        this.Params.Subject = subject;
        this.Params.Body = body;
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            '<b>Send Email</b> To: <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ToRecipient" data-toggle="tooltip" title="Recipient Address" style="margin-bottom:8px; width:600px;">' +
            'CC: <input name="' + guid() + '" type="text" class="form-control" ng-model="action.Params.CcRecipients" data-toggle="tooltip" title="CC Recipient Address" style="margin-bottom:8px; width:600px;">' +
            'BCC: <input name="' + guid() + '" type="text" class="form-control" ng-model="action.Params.BccRecipients" data-toggle="tooltip" title="BCC Recipient Address" style="margin-bottom:8px; width:600px;">' +
            'Subject <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Subject" data-toggle="tooltip" title="Subject" style="margin-bottom:8px; width:600px;">' +
            'Attachment <input name="' + guid() + '" type="text" class="form-control" ng-model="action.Params.Attachment" data-toggle="tooltip" title="Attachment" style="margin-bottom:8px; width:600px;">' +
            'Message <textarea name="' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Body" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}



class EmailProfile extends NetworkAction {
    constructor(profileName) {
        super();
        this.Method = 'EmailProfileSend';
        this.Params.ProfileName = profileName;
    }

    editTemplate() {
        var template = 'Send Email Profile for <input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.ProfileName" data-toggle="tooltip" title="The name of the Email Profile to use.  The Email Profile is defined in the Web UI.">';
        return template;
    }
}



class SNMPTrap extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SNMPTrap';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send SNMP Trap for OID ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.OID" style="width: 225px;" data-toggle="tooltip" title="The OID to use when sending the Trap"> Data ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Message" style="width: 225px;" data-toggle="tooltip" title="The message to send in the Trap"> to ' +
            '<select name="snmptrap-device-' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getSNMPDevices()" data-toggle="tooltip" title="The SNMP Device to use that was defined in the Devices section"' +
            '  data-toggle="tooltip" title="Select a SNMP Device">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n';
        return template;
    }
}



class SNMPSet extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SNMPSet';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send SNMP Set for OID ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.OID" style="width: 225px;" data-toggle="tooltip" title="The OID to send in the Set request"> Data ' +
            '<input name="' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Message" style="width: 225px;" data-toggle="tooltip" title="The value to Set"> to ' +
            '<select name="snmpset-type-' + guid() + '" class="form-control" ng-model="action.Params.Type"  ng-options="type for type in controller.getSNMPTypes()" title="Select the OID type">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n' +
            '<select name="snmpset-device-' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getSNMPDevices()" data-toggle="tooltip" title="The SNMP Device to use that was defined in the Devices section"' +
            '  data-toggle="tooltip" title="Select a SNMP Device">\r\n' +
            '   <option value=""></option>\r\n' +
            '</select>\r\n';
        return template;
    }
}



class HTTPGet extends NetworkAction {
    constructor() {
        super();
        this.Method = 'HTTPGet';
        this.Params = {};
    }

    editTemplate() {
        var template = 'Send HTTP Request to ' +
            '<input name="url-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Url" style="width: 500px;" data-toggle="tooltip" title="The URL to use for the HTTP Request">';
        return template;
    }
}



class HTTPPost extends NetworkAction {
    constructor() {
        super();
        this.Method = 'HTTPPost';
        this.Params = {};
    }

    editTemplate() {
        var template = '<div style="display:inline-grid" class="form-inline">' +
            '<div class="form-group">Send HTTP Post to ' +
            '<input name="url-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Url" style="width: 500px;" data-toggle="tooltip" title="The URL to use for the HTTP Post"></div>' +
            'the following data ' +
            '<textarea name="data-' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Data" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}



class MQTTPublish extends NetworkAction {
    constructor() {
        super();
        this.Method = 'MQTTPublish';
        this.Params = {};
    }

    editTemplate() {
        var template = '<div style="display:inline-grid">' +
            'Publish the MQTT Topic ' +
            '<input name="topic-' + guid() + '" required type="text" class="form-control" ng-model="action.Params.Topic" style="width: 300px;" data-toggle="tooltip" title="The Topic Name"> the following data ' +
            '<textarea name="payload-' + guid() + '" required rows="4" cols="50" class="form-control" ng-model="action.Params.Payload" data-toggle="tooltip" title="Body" style="width:600px;">' +
            '</div>';
        return template;
    }
}



class ProjectorSend extends NetworkAction {
    constructor() {
        super();
        this.Method = 'ProjectorSend';
        this.Params = {};
    }

    editTemplate() {
        var template = '<b>Projector</b>: Use ' +
            '<select name="' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>' +
            ' to Send ' +
            '<select name="' + guid() + '" class="form-control" ng-model="action.Params.DeviceAction"' +
            '  ng-options="command.Type as command.Name for command in controller.getProjectorCommandsForDevice(action.Params.DeviceGUID)"' +
            '  data-toggle="tooltip" title="Select the Command to send">\r\n' +
            '     <option value="">Raw</option>\r\n' +
            '</select>' +
            '<span ng-repeat="arg in controller.getArgsForProjectorDeviceCommand(action.Params.DeviceGUID, action.Params.DeviceAction)">' +
            '  {{arg.Title}}: ' +
            '    <input name="' + guid() + '" type="number" style="width: {{arg.Width}};" class="form-control" ng-model="action.Params[arg.Name]" ng-if="arg.Type == \'number\'" required>\r\n' +
            '</span>\r\n' +
            '<span ng-if="!action.Params.DeviceAction">' +
            ' <input name="projectorsend-message-' + guid() + '" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped characters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />' +
            '</span>';
        return template;
    }
}



class SoundProcessorSend extends NetworkAction {
    constructor() {
        super();
        this.Method = 'SoundProcessorSend';
        this.Params = {};
    }

    editTemplate() {
        var template = '<b>Sound Processor</b>: Use ' +
            '<select name="soundprocessorsend-device' + guid() + '" class="form-control" ng-model="action.Params.DeviceGUID" ng-options="device.GUID as device.Name for device in controller.getDeviceProfiles()"' +
            '  data-toggle="tooltip" title="Select a Device that the following data wil be sent to" required>\r\n' +
            '   <option value=""></option></select>' +
            ' to Send ' +
            '<select name="soundprocessorsend-command' + guid() + '" class="form-control" ng-model="action.Params.DeviceAction"' +
            '  ng-options="command.Type as command.Name for command in controller.getSoundProcessorCommandsForDevice(action.Params.DeviceGUID)"' +
            '  data-toggle="tooltip" title="Select the Command to send">\r\n' +
            '     <option value="">Raw</option>\r\n' +
            '</select>' +
            '<span ng-repeat="arg in controller.getArgsForSoundProcessorDeviceCommand(action.Params.DeviceGUID, action.Params.DeviceAction)">' +
            '  {{arg.Title}}: ' +
            '    <input name="' + guid() + '" type="number" style="width: {{arg.Width}};" class="form-control" ng-model="action.Params[arg.Name]" ng-if="arg.Type == \'number\'" required>\r\n' +
            '</span>\r\n' +
            '<span ng-if="!action.Params.DeviceAction">' +
            ' <input name="soundprocessorsend-message' + guid() + '" class="form-control" type="text" ng-model="action.Params.Message" ' +
            '  data-toggle="tooltip" title="The data to be sent to the selected device.  Escaped characters will be converted before being sent.  If special characters are needed, please use \\x## to send the ASCII hex value." style="width:300px;" required />' +
            '</span>';
        return template;
    }
}