function parseDinControlAction(json) {
    var method = json.Method;

    switch (method) {
        case 'SoftInvert':
            return new DinSoftInvert();

        case 'SetCounter':
            return new DinSetCounter();

        case 'ResetUsageMeter':
            return new DinResetUsageMeter();

        case 'ClearLatch':
            return new DinClearLatch();

        default:
            throw new Error('Unknown DIN Action Method: ' + JSON.stringify(json, null, 2));
    }
}



class DinControl extends Action {
    constructor() {
        super();
        this.Type = 'DinControl';
        this.Method = 'void';
        this.Params = {};
    }
}


class DinResetUsageMeter extends DinControl {
    constructor(channel) {
        super();
        this.Method = 'ResetUsageMeter';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Reset Usage Meter for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />';
        return template;
    }
}


class DinSetCounter extends DinControl {
    constructor(channel, value) {
        super();
        this.Method = 'SetCounter';
        this.Params.Channel = channel || 1;
        this.Params.Value = value || 0;
    }

    editTemplate() {
        var template = 'Set Counter for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            ' to ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Value"' +
            ' data-toggle="tooltip" title="Integer Value" style="width: 75px;" required />';
        return template;
    }
}


class DinSoftInvert extends DinControl {
    constructor(channel, inverted) {
        super();
        this.Method = 'SoftInvert';
        this.Params.Channel = channel || 1;
        this.Params.Inverted = inverted || true;
    }

    editTemplate() {
        var template = 'Soft Invert Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />' +
            '<input type="checkbox" style="margin-left: 32px;" ng-model="action.Params.Inverted">';
        return template;
    }
}


class DinClearLatch extends DinControl {
    constructor(channel, inverted) {
        super();
        this.Method = 'ClearLatch';
        this.Params.Channel = channel || 1;
    }

    editTemplate() {
        var template = 'Clear Latch for Digital Input ' +
            '<input name="' + guid() + '" class="form-control" type="text" ng-model="action.Params.Channel"' +
            ' data-toggle="tooltip" title="Digital Input (1 - 12)" style="width: 75px;" required />';
        return template;
    }
}
