/*
 * Decompiled with CFR 0.152.
 */
package com.integpg.tasker;

import com.integpg.janoslib.io.AppLog;
import com.integpg.janoslib.text.QuickDateFormat;
import com.integpg.tasker.ast.ASTNode;
import com.integpg.tasker.ast.ASTParser;
import java.text.DecimalFormat;
import java.util.regex.Matcher;
import java.util.regex.Pattern;

public class ExpressionReplacer {
    protected static final QuickDateFormat QUICK_DATE_FORMAT = new QuickDateFormat("MM/dd/yyyy HH:mm:ss.fff");
    protected static final DecimalFormat DECIMAL_FORMAT = new DecimalFormat("0.00");
    protected static Pattern ReplacePattern = Pattern.compile("{{[\\w()\\\\. -]*}}");
    protected final String _original;

    public ExpressionReplacer(String original) {
        this._original = original;
    }

    public String getOriginal() {
        return this._original;
    }

    public String evaluate() {
        Matcher matcher;
        StringBuilder sb = new StringBuilder();
        int lastIndex = 0;
        while (this._original.length() > lastIndex && (matcher = ReplacePattern.matcher(this._original.substring(lastIndex))).find()) {
            for (int i = 0; i < matcher.groupCount(); ++i) {
                String newValue = this.replace(matcher.group(i).substring(2, matcher.group(i).length() - 2));
                sb.append(this._original.substring(lastIndex, lastIndex + matcher.start(i)));
                sb.append(newValue);
                lastIndex += matcher.end(i);
            }
        }
        if (this._original.length() > lastIndex) {
            sb.append(this._original.substring(lastIndex));
        }
        return sb.toString();
    }

    public String replace(String replaceString) {
        System.out.println("ExpressionStatementReplacer.replace called: " + replaceString);
        switch (replaceString) {
            case "milliseconds": {
                return Long.toString(System.currentTimeMillis());
            }
            case "timestamp": {
                return QUICK_DATE_FORMAT.format(System.currentTimeMillis());
            }
        }
        try {
            ASTParser expressionParser = new ASTParser(replaceString, null);
            ASTNode expressionNode = expressionParser.parse();
            Object result = expressionNode.evaluate();
            System.out.println("expressionNode: " + expressionParser.getExpressionString() + " = " + result);
            System.out.println("");
            if (result instanceof Double) {
                if (Double.isNaN((Double)result)) {
                    return "null";
                }
                return DECIMAL_FORMAT.format(result);
            }
            return String.valueOf(result);
        }
        catch (Exception ex) {
            AppLog.error(ex);
            return "";
        }
    }

    public String toString() {
        return this._original + " = " + this.evaluate();
    }
}

